---
id: 67d1f348f2cc9eab9d0b4ff4
title: Step 19
challengeType: 0
dashedName: step-19
---

# --description--

Similarly, users should be able to click on the email address and send an email from their default email client.

Here is how you can make email addresses clickable:

```html
<a href="mailto:contact@company.com">contact@company.com</a>
```

For this final step, wrap the text `fake@email.com` in an anchor element and use `mailto:` to make it a clickable email address.

And with those changes, your blog page is now complete.

# --hints--

You should wrap the text `fake@email.com` in an `a` element.

```js
const secondPElement = document.querySelector('footer #contact address p:nth-of-type(2)');
const link = secondPElement.querySelector('a');
assert.exists(link);
assert.strictEqual(link.textContent.trim(), "fake@email.com");
```

Your `a` element should have an `href` attribute.

```js
const secondPElement = document.querySelector('footer #contact address p:nth-of-type(2)');
const link = secondPElement.querySelector('a');
assert.exists(link.getAttribute('href'));
```

The `href` attribute for your new `a` element should be set to `mailto:fake@email.com`.

```js
const secondPElement = document.querySelector('footer #contact address p:nth-of-type(2)');
const link = secondPElement.querySelector('a');
assert.strictEqual(link.getAttribute('href'), "mailto:fake@email.com");
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <title>Mr. Whiskers' Blog</title>
    <meta charset="UTF-8" />
  </head>
  <body>
    <header>
      <h1>Welcome to Mr. Whiskers' Blog Page!</h1>
      <figure>
        <img
          src="https://cdn.freecodecamp.org/curriculum/css-photo-gallery/1.jpg"
          alt="a cat in the garden"
        />
        <figcaption>Mr. Whiskers in the Garden</figcaption>
      </figure>
      <nav>
        <ul>
          <li><a href="#about">About</a></li>
          <li><a href="#posts">Posts</a></li>
          <li><a href="#contact">Contact</a></li>
        </ul>
      </nav>
    </header>
    <main>
      <section id="about">
        <h2>About</h2>
        <p>
          Hi there! I'm Jane Doe, a passionate writer who finds endless inspiration in the antics of my beloved cat, Mr. Whiskers.
        </p>
        <p>
          His playful nature and boundless energy keeps me on my toes. I love him so much.
        </p>
      </section>
      <section id="posts">
        <h2>Posts</h2>

        <article>
          <h3>Mr. Whiskers' First Day Home</h3>
          <p>
            Lorem ipsum dolor sit amet consectetur adipisicing elit. Quisquam
            quod, voluptates, quae, quos quibusdam dolorum quia nemo repudiandae
            quidem voluptatum quas. Quisquam quod, voluptates, quae, quos
            quibusdam dolorum quia nemo repudiandae quidem voluptatum quas.
          </p>
          <p>
            Lorem ipsum dolor sit amet consectetur adipisicing elit. Quisquam
            quod, voluptates, quae, quos quibusdam dolorum quia nemo repudiandae
            quidem voluptatum quas. Quisquam quod, voluptates, quae, quos
            quibusdam dolorum quia nemo repudiandae quidem voluptatum quas.
          </p>
        </article>
        <article>
          <h3>Mr. Whiskers' First Bath</h3>
          <p>
            Lorem ipsum dolor sit amet consectetur adipisicing elit. Quisquam
            quod, voluptates, quae, quos quibusdam dolorum quia nemo repudiandae
            quidem voluptatum quas. Quisquam quod, voluptates, quae, quos
            quibusdam dolorum quia nemo repudiandae quidem voluptatum quas.
          </p>
          <p>
            Lorem ipsum dolor sit amet consectetur adipisicing elit. Quisquam
            quod, voluptates, quae, quos quibusdam dolorum quia nemo repudiandae
            quidem voluptatum quas. Quisquam quod, voluptates, quae, quos
            quibusdam dolorum quia nemo repudiandae quidem voluptatum quas.
          </p>
        </article>
        <article>
          <h3>Mr. Whiskers' First Birthday Party</h3>
          <p>
            Lorem ipsum dolor sit amet consectetur adipisicing elit. Quisquam
            quod, voluptates, quae, quos quibusdam dolorum quia nemo repudiandae
            quidem voluptatum quas. Quisquam quod, voluptates, quae, quos
            quibusdam dolorum quia nemo repudiandae quidem voluptatum quas.
          </p>
          <p>
            Lorem ipsum dolor sit amet consectetur adipisicing elit. Quisquam
            quod, voluptates, quae, quos quibusdam dolorum quia nemo repudiandae
            quidem voluptatum quas. Quisquam quod, voluptates, quae, quos
            quibusdam dolorum quia nemo repudiandae quidem voluptatum quas.
          </p>
        </article>
      </section>
    </main>
--fcc-editable-region--
    <footer>
        <section id="contact">
            <h2>Contact</h2>
            <address>
                <p>Phone: <a href="tel:5555555555">555-555-5555</a></p>
                <p>Email: fake@email.com</p>
            </address>
        </section>
    </footer>
--fcc-editable-region--
  </body>
</html>
```

# --solutions--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <title>Mr. Whiskers' Blog</title>
    <meta charset="UTF-8" />
  </head>
  <body>
    <header>
      <h1>Welcome to Mr. Whiskers' Blog Page!</h1>
      <figure>
        <img
          src="https://cdn.freecodecamp.org/curriculum/css-photo-gallery/1.jpg"
          alt="a cat in the garden"
        />
        <figcaption>Mr. Whiskers in the Garden</figcaption>
      </figure>
      <nav>
        <ul>
          <li><a href="#about">About</a></li>
          <li><a href="#posts">Posts</a></li>
          <li><a href="#contact">Contact</a></li>
        </ul>
      </nav>
    </header>
    <main>
      <section id="about">
        <h2>About</h2>
        <p>
          Hi there! I'm Jane Doe, a passionate writer who finds endless inspiration in the antics of my beloved cat, Mr. Whiskers.
        </p>
        <p>
          His playful nature and boundless energy keeps me on my toes. I love him so much.
        </p>
      </section>
      <section id="posts">
        <h2>Posts</h2>

        <article>
          <h3>Mr. Whiskers' First Day Home</h3>
          <p>
            Lorem ipsum dolor sit amet consectetur adipisicing elit. Quisquam
            quod, voluptates, quae, quos quibusdam dolorum quia nemo repudiandae
            quidem voluptatum quas. Quisquam quod, voluptates, quae, quos
            quibusdam dolorum quia nemo repudiandae quidem voluptatum quas.
          </p>
          <p>
            Lorem ipsum dolor sit amet consectetur adipisicing elit. Quisquam
            quod, voluptates, quae, quos quibusdam dolorum quia nemo repudiandae
            quidem voluptatum quas. Quisquam quod, voluptates, quae, quos
            quibusdam dolorum quia nemo repudiandae quidem voluptatum quas.
          </p>
        </article>
        <article>
          <h3>Mr. Whiskers' First Bath</h3>
          <p>
            Lorem ipsum dolor sit amet consectetur adipisicing elit. Quisquam
            quod, voluptates, quae, quos quibusdam dolorum quia nemo repudiandae
            quidem voluptatum quas. Quisquam quod, voluptates, quae, quos
            quibusdam dolorum quia nemo repudiandae quidem voluptatum quas.
          </p>
          <p>
            Lorem ipsum dolor sit amet consectetur adipisicing elit. Quisquam
            quod, voluptates, quae, quos quibusdam dolorum quia nemo repudiandae
            quidem voluptatum quas. Quisquam quod, voluptates, quae, quos
            quibusdam dolorum quia nemo repudiandae quidem voluptatum quas.
          </p>
        </article>
        <article>
          <h3>Mr. Whiskers' First Birthday Party</h3>
          <p>
            Lorem ipsum dolor sit amet consectetur adipisicing elit. Quisquam
            quod, voluptates, quae, quos quibusdam dolorum quia nemo repudiandae
            quidem voluptatum quas. Quisquam quod, voluptates, quae, quos
            quibusdam dolorum quia nemo repudiandae quidem voluptatum quas.
          </p>
          <p>
            Lorem ipsum dolor sit amet consectetur adipisicing elit. Quisquam
            quod, voluptates, quae, quos quibusdam dolorum quia nemo repudiandae
            quidem voluptatum quas. Quisquam quod, voluptates, quae, quos
            quibusdam dolorum quia nemo repudiandae quidem voluptatum quas.
          </p>
        </article>
      </section>
    </main>
    <footer>
      <section id="contact">
        <h2>Contact</h2>
        <address>
          <p>Phone: <a href="tel:5555555555">555-555-5555</a></p>
          <p>Email: <a href="mailto:fake@email.com">fake@email.com</a></p>
        </address>
      </section>
    </footer>
  </body>
</html>
```
