---
id: 5f3ef6e01f288a026d709587
title: Step 63
challengeType: 0
dashedName: step-63
---

# --description--

You can use an `hr` element to display a divider between sections of different content.

```html
<section>
  <h2>Things cats love</h2>
  <hr>
  <p>Cats love lasagna.</p>
</section>
```

First, add an `hr` element between the `p` element with the class `established` and the first `section` element.

Note that the `hr` element is a void element.

# --hints--

You should add an `hr` element.

```js
assert.match(code, /<hr\s?\/?>/i);
```

The `hr` element is a void element, it should not have an end tag `</hr>`.

```js
assert.notMatch(code, /<\/hr>/i);
```

You should not change your existing `p` element with the class `established`.

```js
const pElementCount = document.querySelectorAll('p.established')?.length;
assert.strictEqual(pElementCount, 1);
```

You should not change your existing `main` element.

```js
const mainElementCount = document.querySelectorAll('main')?.length;
assert.strictEqual(mainElementCount, 1);
```

Your `hr` element should be between your `p` element and your `section` element.

```js
const hrElement = document.querySelector('hr');
assert.strictEqual(hrElement?.previousElementSibling?.tagName, 'P');
assert.strictEqual(hrElement?.nextElementSibling?.tagName, 'SECTION');
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Cafe Menu</title>
    <link href="styles.css" rel="stylesheet"/>
  </head>
  <body>
    <div class="menu">
--fcc-editable-region--
      <main>
        <h1>CAMPER CAFE</h1>
        <p class="established">Est. 2020</p>
        <section>
          <h2>Coffee</h2>
          <article class="item">
            <p class="flavor">French Vanilla</p><p class="price">3.00</p>
          </article>
          <article class="item">
            <p class="flavor">Caramel Macchiato</p><p class="price">3.75</p>
          </article>
          <article class="item">
            <p class="flavor">Pumpkin Spice</p><p class="price">3.50</p>
          </article>
          <article class="item">
            <p class="flavor">Hazelnut</p><p class="price">4.00</p>
          </article>
          <article class="item">
            <p class="flavor">Mocha</p><p class="price">4.50</p>
          </article>
        </section>
        <section>
          <h2>Desserts</h2>
          <article class="item">
            <p class="dessert">Donut</p><p class="price">1.50</p>
          </article>
          <article class="item">
            <p class="dessert">Cherry Pie</p><p class="price">2.75</p>
          </article>
          <article class="item">
            <p class="dessert">Cheesecake</p><p class="price">3.00</p>
          </article>
          <article class="item">
            <p class="dessert">Cinnamon Roll</p><p class="price">2.50</p>
          </article>
        </section>
      </main>
--fcc-editable-region--
      <footer>
        <address>
          <p>
            <a href="https://www.freecodecamp.org" target="_blank">Visit our website</a>
          </p>
          <p>123 Free Code Camp Drive</p>
        </address>
      </footer>
    </div>
  </body>
</html>
```

```css
body {
  background-image: url(https://cdn.freecodecamp.org/curriculum/css-cafe/beans.jpg);
  font-family: sans-serif;
}

h1 {
  font-size: 40px;
}

h2 {
  font-size: 30px;
}

.established {
  font-style: italic;
}

h1, h2, p {
  text-align: center;
}

.menu {
  width: 80%;
  background-color: burlywood;
  margin-left: auto;
  margin-right: auto;
  padding: 20px;
  max-width: 500px;
}

h1, h2 {
  font-family: Impact, serif;
}

.item p {
  display: inline-block;
}

.flavor, .dessert {
  text-align: left;
  width: 75%;
}

.price {
  text-align: right;
  width: 25%
}
```

