---
id: 5dc24614f86c76b9248c6ebd
title: Step 10
challengeType: 0
dashedName: step-10
---

# --description--

You can link to another page with the anchor (`a`) element. 

Here is an example linking to `https://www.freecodecamp.org`:

```html
<a href="https://www.freecodecamp.org"></a>
```

Add an anchor element after the paragraph that links to `https://freecatphotoapp.com`. At this point, the link won't show up in the preview.

# --hints--

Your anchor (`a`) element should have an opening tag. Opening tags have this syntax: `<elementName>`.

```js
assert.exists(document.querySelector('a'));
```

Your anchor (`a`) element should have a closing tag. Closing tags have a `/` just after the `<` character.

```js
assert.match(code, /<\/a\>/);
```

Your anchor (`a`) element should be below the `p` element. You have them in the wrong order.

```js
const collection = [...document.querySelectorAll('a, p')].map(
  (node) => node.nodeName
);
assert.isBelow(collection.indexOf('P'), collection.indexOf('A'));
```

Your anchor (`a`) element does not have an `href` attribute. Check that there is a space after the opening tag's name and/or there are spaces before all attribute names.

```js
assert.isTrue(document.querySelector('a')?.hasAttribute('href'));
```

Your anchor (`a`) element should link to `https://freecatphotoapp.com`. You have either omitted the URL or have a typo.

```js
assert.equal(
  document.querySelector('a')?.getAttribute('href'),
    'https://freecatphotoapp.com'
);
```

Although you have set the anchor (`a`) element's `href` attribute to the correct link, it is recommended to always surround the value of an attribute with quotation marks.

```js
assert.notMatch(
  code, /\<a\s+href\s*=\s*https:\/\/www.freecodecamp.org\/cat-photos/
);
```

# --seed--

## --seed-contents--

```html
<html>
  <body>
    <main>
      <h1>CatPhotoApp</h1>
      <h2>Cat Photos</h2>
      <!-- TODO: Add link to cat photos -->
--fcc-editable-region--
      <p>Everyone loves cute cats online!</p>
      
--fcc-editable-region--
      <img src="https://cdn.freecodecamp.org/curriculum/cat-photo-app/relaxing-cat.jpg" alt="A cute orange cat lying on its back.">
    </main>
  </body>
</html>
```
