---
id: 68e5293bd00d2fe134f58985
title: Step 13
challengeType: 20
dashedName: step-13
---

# --description--

Since `PercentageDiscount` inherits from an abstract class, you must implement all abstract methods. Start by implementing the `is_applicable` method. The `is_applicable` method should take `self`, `product: Product`, and `user_tier: str` as parameters. It should have a return type hint of `bool`.

This method should determine whether a percentage discount is valid. Return `True` if `self.percent` is less than or equal to `70`, otherwise return `False`. This prevents unrealistic discounts like 90% off.

# --hints--

Your `PercentageDiscount` class should have an `is_applicable` method.

```js
({
  test: () => runPython(`assert _Node(_code).find_class("PercentageDiscount").has_function("is_applicable")`)
})
```

Your `is_applicable` method should have parameters `self`, `product: Product`, and `user_tier: str`.

```js
({
  test: () => runPython(`assert _Node(_code).find_class("PercentageDiscount").find_function("is_applicable").has_args("self,product:Product,user_tier:str")`)
})
```

Your `is_applicable` method should return `True` when `self.percent` is less than or equal to `70`.

```js
({
  test: () => runPython(`
    # Add stub method to make class instantiable for testing
    class TestPercentageDiscount(PercentageDiscount):
        def apply_discount(self, product):
            return 0

    test_product = Product("Test", 100.0)
    discount1 = TestPercentageDiscount(50)
    discount2 = TestPercentageDiscount(70)
    assert discount1.is_applicable(test_product, "regular") == True
    assert discount2.is_applicable(test_product, "regular") == True
  `)
})
```

Your `is_applicable` method should return `False` when `self.percent` is greater than `70`.

```js
({
  test: () => runPython(`
    # Add stub method to make class instantiable for testing
    class TestPercentageDiscount(PercentageDiscount):
        def apply_discount(self, product):
            return 0

    test_product = Product("Test", 100.0)
    discount = TestPercentageDiscount(75)
    assert discount.is_applicable(test_product, "regular") == False
  `)
})
```

Your `is_applicable` method should have a return type hint of `bool`.

```js
({
  test: () => runPython(`assert _Node(_code).find_class("PercentageDiscount").find_function("is_applicable").has_returns("bool")`)
})
```

# --seed--

## --seed-contents--

```py
from abc import ABC, abstractmethod

class Product:
    def __init__(self, name: str, price: float) -> None:
        self.name = name
        self.price = price

    def __str__(self) -> str:
        return f'{self.name} - ${self.price}'

class DiscountStrategy(ABC):
    @abstractmethod
    def is_applicable(self, product: Product, user_tier: str) -> bool:
        pass

    @abstractmethod
    def apply_discount(self, product: Product) -> float:
        pass

class PercentageDiscount(DiscountStrategy):
    def __init__(self, percent: int) -> None:
        self.percent = percent
--fcc-editable-region--
    
--fcc-editable-region--
product = Product('Wireless Mouse', 50.0)
print(product)
```
