---
id: 68e5293bd00d2fe134f58987
title: Step 16
challengeType: 20
dashedName: step-16
---

# --description--

Now you'll create another discount strategy. Create a class named `FixedAmountDiscount` that inherits from `DiscountStrategy`.

Give it an `__init__` method that takes `self` and `amount` as parameters. Give `amount` parameter a type hint of `int` and a return type hint of `None` for the method. Inside the `__init__` method, store `amount` as an instance attribute.

# --hints--

You should create a class named `FixedAmountDiscount`.

```js
({
  test: () => runPython(`assert _Node(_code).has_class("FixedAmountDiscount")`)
})
```

Your `FixedAmountDiscount` class should inherit from `DiscountStrategy`.

```js
({
  test: () => runPython(`assert _Node(_code).find_class("FixedAmountDiscount").inherits_from("DiscountStrategy")`)
})
```

Your `FixedAmountDiscount` class should have an `__init__` method.

```js
({
  test: () => runPython(`assert _Node(_code).find_class("FixedAmountDiscount").has_function("__init__")`)
})
```

Your `__init__` method should have parameters `self` and `amount: int`.

```js
({
  test: () => runPython(`assert _Node(_code).find_class("FixedAmountDiscount").find_function("__init__").has_args("self, amount: int")`)
})
```

Your `__init__` method should have a return type of `None`.

```js
({
  test: () => runPython(`assert _Node(_code).find_class("FixedAmountDiscount").find_function("__init__").has_returns("None")`)
})
```

You should assign `amount` to `self.amount` inside your `__init__` method.

```js
({
  test: () => runPython(`
  assert _Node(_code).find_class("FixedAmountDiscount").find_function("__init__").has_stmt("self.amount = amount")
  `)
})
```

# --seed--

## --seed-contents--

```py
from abc import ABC, abstractmethod

class Product:
    def __init__(self, name: str, price: float) -> None:
        self.name = name
        self.price = price

    def __str__(self) -> str:
        return f'{self.name} - ${self.price}'

class DiscountStrategy(ABC):
    @abstractmethod
    def is_applicable(self, product: Product, user_tier: str) -> bool:
        pass

    @abstractmethod
    def apply_discount(self, product: Product) -> float:
        pass

class PercentageDiscount(DiscountStrategy):
    def __init__(self, percent: int) -> None:
        self.percent = percent

    def is_applicable(self, product: Product, user_tier: str) -> bool:
        return self.percent <= 70

    def apply_discount(self, product: Product) -> float:
        return product.price * (1 - self.percent / 100)
--fcc-editable-region--

--fcc-editable-region--
product = Product('Wireless Mouse', 50.0)
print(product)

discount = PercentageDiscount(10)
print(discount.apply_discount(product))
```
