---
id: 68e5293bd00d2fe134f58989
title: Step 18
challengeType: 20
dashedName: step-18
---

# --description--

Now implement the `apply_discount` method for `FixedAmountDiscount`. This method should subtract the fixed amount from the product price and return the new price.

# --hints--

Your `FixedAmountDiscount` class should have an `apply_discount` method.

```js
({
  test: () => runPython(`assert _Node(_code).find_class("FixedAmountDiscount").has_function("apply_discount")`)
})
```

Your `apply_discount` method should have parameters `self` and `product: Product`.

```js
({
  test: () => runPython(`assert _Node(_code).find_class("FixedAmountDiscount").find_function("apply_discount").has_args("self, product: Product")`)
})
```

Your `apply_discount` method should have a return type hint of `-> float`.

```js
({
  test: () => runPython(`assert _Node(_code).find_class("FixedAmountDiscount").find_function("apply_discount").has_returns("float")`)
})
```

Your `apply_discount` method should return `product.price - self.amount`.

```js
({
  test: () => runPython(`
    test_product = Product("Test", 100.0)
    discount = FixedAmountDiscount(15)
    result = discount.apply_discount(test_product)
    assert result == 85.0
  `)
})
```

# --seed--

## --seed-contents--

```py
from abc import ABC, abstractmethod

class Product:
    def __init__(self, name: str, price: float) -> None:
        self.name = name
        self.price = price

    def __str__(self) -> str:
        return f'{self.name} - ${self.price}'

class DiscountStrategy(ABC):
    @abstractmethod
    def is_applicable(self, product: Product, user_tier: str) -> bool:
        pass

    @abstractmethod
    def apply_discount(self, product: Product) -> float:
        pass

class PercentageDiscount(DiscountStrategy):
    def __init__(self, percent: int) -> None:
        self.percent = percent

    def is_applicable(self, product: Product, user_tier: str) -> bool:
        return self.percent <= 70

    def apply_discount(self, product: Product) -> float:
        return product.price * (1 - self.percent / 100)

class FixedAmountDiscount(DiscountStrategy):
    def __init__(self, amount: int) -> None:
        self.amount = amount

    def is_applicable(self, product: Product, user_tier: str) -> bool:
        return product.price * 0.9 > self.amount
--fcc-editable-region--
    
--fcc-editable-region--
product = Product('Wireless Mouse', 50.0)
print(product)

discount = PercentageDiscount(10)
print(discount.apply_discount(product))
```
