---
id: 68e5293bd00d2fe134f5898a
title: Step 19
challengeType: 20
dashedName: step-19
---

# --description--

Let's test your new discount strategy. After the existing code, create an instance of `FixedAmountDiscount` with an amount of `5` and assign it to a variable named `fixed_discount`. Then apply this discount to the product and print the result.

# --hints--

You should create a variable named `fixed_discount` with a `FixedAmountDiscount` instance.

```js
({
  test: () => runPython(`
    assert _Node(_code).has_variable("fixed_discount")
    assert isinstance(fixed_discount, FixedAmountDiscount)
  `)
})
```

Your `FixedAmountDiscount` instance should be initialized with amount `5`.

```js
({
  test: () => runPython(`assert fixed_discount.amount == 5`)
})
```

You should call `fixed_discount.apply_discount(product)` and print the result.

```js
({
  test: () => runPython(`
    assert _Node(_code).has_call("print(fixed_discount.apply_discount(product))")
  `)
})
```

# --seed--

## --seed-contents--

```py
from abc import ABC, abstractmethod

class Product:
    def __init__(self, name: str, price: float) -> None:
        self.name = name
        self.price = price

    def __str__(self) -> str:
        return f'{self.name} - ${self.price}'

class DiscountStrategy(ABC):
    @abstractmethod
    def is_applicable(self, product: Product, user_tier: str) -> bool:
        pass

    @abstractmethod
    def apply_discount(self, product: Product) -> float:
        pass

class PercentageDiscount(DiscountStrategy):
    def __init__(self, percent: int) -> None:
        self.percent = percent

    def is_applicable(self, product: Product, user_tier: str) -> bool:
        return self.percent <= 70

    def apply_discount(self, product: Product) -> float:
        return product.price * (1 - self.percent / 100)

class FixedAmountDiscount(DiscountStrategy):
    def __init__(self, amount: int) -> None:
        self.amount = amount

    def is_applicable(self, product: Product, user_tier: str) -> bool:
        return product.price * 0.9 > self.amount

    def apply_discount(self, product: Product) -> float:
        return product.price - self.amount

product = Product('Wireless Mouse', 50.0)
print(product)

discount = PercentageDiscount(10)
print(discount.apply_discount(product))
--fcc-editable-region--

--fcc-editable-region--
```
