---
id: 68e52994bc7ea2e3dec5309d
title: Step 20
challengeType: 20
dashedName: step-20
---

# --description--

Now let's create a third discount strategy for premium users. Create a class named `PremiumUserDiscount` that inherits from `DiscountStrategy`.

Unlike the previous strategies, this one doesn't need an `__init__` method because it doesn't store any configuration. It will apply a fixed 20% discount to all premium users.

For now, just create the empty class that inherits from `DiscountStrategy` using `pass`.

# --hints--

You should create a class named `PremiumUserDiscount`.

```js
({
  test: () => runPython(`assert _Node(_code).has_class("PremiumUserDiscount")`)
})
```

Your `PremiumUserDiscount` class should inherit from `DiscountStrategy`.

```js
({
  test: () => runPython(`assert _Node(_code).find_class("PremiumUserDiscount").inherits_from("DiscountStrategy")`)
})
```

# --seed--

## --seed-contents--

```py
from abc import ABC, abstractmethod

class Product:
    def __init__(self, name: str, price: float) -> None:
        self.name = name
        self.price = price

    def __str__(self) -> str:
        return f'{self.name} - ${self.price}'

class DiscountStrategy(ABC):
    @abstractmethod
    def is_applicable(self, product: Product, user_tier: str) -> bool:
        pass

    @abstractmethod
    def apply_discount(self, product: Product) -> float:
        pass

class PercentageDiscount(DiscountStrategy):
    def __init__(self, percent: int) -> None:
        self.percent = percent

    def is_applicable(self, product: Product, user_tier: str) -> bool:
        return self.percent <= 70

    def apply_discount(self, product: Product) -> float:
        return product.price * (1 - self.percent / 100)

class FixedAmountDiscount(DiscountStrategy):
    def __init__(self, amount: int) -> None:
        self.amount = amount

    def is_applicable(self, product: Product, user_tier: str) -> bool:
        return product.price * 0.9 > self.amount

    def apply_discount(self, product: Product) -> float:
        return product.price - self.amount
--fcc-editable-region--

--fcc-editable-region--
product = Product('Wireless Mouse', 50.0)
print(product)

discount = PercentageDiscount(10)
print(discount.apply_discount(product))

fixed_discount = FixedAmountDiscount(5)
print(fixed_discount.apply_discount(product))
```
