---
id: 68e52994bc7ea2e3dec5309e
title: Step 21
challengeType: 20
dashedName: step-21
---

# --description--

Implement the `is_applicable` method for `PremiumUserDiscount`. This method should check if the user is a premium member.

Return `True` if `user_tier.lower()` equals `'premium'`, otherwise return `False`. Using `.lower()` ensures the check is case-insensitive.

# --hints--

Your `PremiumUserDiscount` class should have an `is_applicable` method.

```js
({
  test: () => runPython(`assert _Node(_code).find_class("PremiumUserDiscount").has_function("is_applicable")`)
})
```

Your `is_applicable` method should have parameters `self`, `product: Product`, and `user_tier: str`.

```js
({
  test: () => runPython(`assert _Node(_code).find_class("PremiumUserDiscount").find_function("is_applicable").has_args("self, product:Product, user_tier:str")`)
})
```

Your `is_applicable` method should have a return type hint of `-> bool`.

```js
({
  test: () => runPython(`assert _Node(_code).find_class("PremiumUserDiscount").find_function("is_applicable").has_returns("bool")`)
})
```

Your `is_applicable` method should return `True` when `user_tier.lower()` equals `'premium'`.

```js
({
  test: () => runPython(`
    # Add stub method to make class instantiable for testing
    class TestPremiumUserDiscount(PremiumUserDiscount):
        def apply_discount(self, product):
            return 0

    test_product = Product("Test", 100.0)
    discount = TestPremiumUserDiscount()
    assert discount.is_applicable(test_product, "Premium") == True
    assert discount.is_applicable(test_product, "premium") == True
    assert discount.is_applicable(test_product, "PREMIUM") == True
  `)
})
```

Your `is_applicable` method should return `False` when `user_tier` is not `'premium'`.

```js
({
  test: () => runPython(`
    # Add stub method to make class instantiable for testing
    class TestPremiumUserDiscount(PremiumUserDiscount):
        def apply_discount(self, product):
            return 0

    test_product = Product("Test", 100.0)
    discount = TestPremiumUserDiscount()
    assert discount.is_applicable(test_product, "regular") == False
    assert discount.is_applicable(test_product, "standard") == False
  `)
})
```

# --seed--

## --seed-contents--

```py
from abc import ABC, abstractmethod

class Product:
    def __init__(self, name: str, price: float) -> None:
        self.name = name
        self.price = price

    def __str__(self) -> str:
        return f'{self.name} - ${self.price}'

class DiscountStrategy(ABC):
    @abstractmethod
    def is_applicable(self, product: Product, user_tier: str) -> bool:
        pass

    @abstractmethod
    def apply_discount(self, product: Product) -> float:
        pass

class PercentageDiscount(DiscountStrategy):
    def __init__(self, percent: int) -> None:
        self.percent = percent

    def is_applicable(self, product: Product, user_tier: str) -> bool:
        return self.percent <= 70

    def apply_discount(self, product: Product) -> float:
        return product.price * (1 - self.percent / 100)

class FixedAmountDiscount(DiscountStrategy):
    def __init__(self, amount: int) -> None:
        self.amount = amount

    def is_applicable(self, product: Product, user_tier: str) -> bool:
        return product.price * 0.9 > self.amount

    def apply_discount(self, product: Product) -> float:
        return product.price - self.amount

--fcc-editable-region--
class PremiumUserDiscount(DiscountStrategy):
    pass
--fcc-editable-region--
product = Product('Wireless Mouse', 50.0)
print(product)

discount = PercentageDiscount(10)
print(discount.apply_discount(product))

fixed_discount = FixedAmountDiscount(5)
print(fixed_discount.apply_discount(product))
```
