---
id: 68e7a24b2482bd5fa88774fa
title: Step 29
challengeType: 20
dashedName: step-29
---

# --description--

Now, remove the following lines from the bottom of your code:

- `print(product)`
- `discount = PercentageDiscount(10)`
- `print(discount.apply_discount(product))`
- `fixed_discount = FixedAmountDiscount(5)`
- `print(fixed_discount.apply_discount(product))`

# --hints--

You should not have the line `print(product)` in your code.

```js
({ test: () => assert.isFalse(runPython(`_Node(_code).has_call('print(product)')`
))
})
```

You should not have the line `discount = PercentageDiscount(10)` in your code.

```js
({ test: () => assert.isFalse(runPython(`_Node(_code).has_stmt('discount = PercentageDiscount(10)')`
))
})
```

You should not have the line `print(discount.apply_discount(product))` in your code.

```js
({ test: () => assert.isFalse(runPython(`_Node(_code).has_call('print(discount.apply_discount(product))')`
))
})
```

You should not have the line `fixed_discount = FixedAmountDiscount(5)` in your code.

```js

({ test: () => assert.isFalse(runPython(`_Node(_code).has_stmt('fixed_discount = FixedAmountDiscount(5)')`
))
})
```

You should not have the line `print(fixed_discount.apply_discount(product))` in your code.

```js
({ 
    test: () => assert.isFalse(runPython(`_Node(_code).has_call('print(fixed_discount.apply_discount(product))')`
))
})
```

# --seed--

## --seed-contents--

```py
from abc import ABC, abstractmethod
from typing import List

class Product:
    def __init__(self, name: str, price: float) -> None:
        self.name = name
        self.price = price

    def __str__(self) -> str:
        return f'{self.name} - ${self.price}'

class DiscountStrategy(ABC):
    @abstractmethod
    def is_applicable(self, product: Product, user_tier: str) -> bool:
        pass

    @abstractmethod
    def apply_discount(self, product: Product) -> float:
        pass

class PercentageDiscount(DiscountStrategy):
    def __init__(self, percent: int) -> None:
        self.percent = percent

    def is_applicable(self, product: Product, user_tier: str) -> bool:
        return self.percent <= 70

    def apply_discount(self, product: Product) -> float:
        return product.price * (1 - self.percent / 100)

class FixedAmountDiscount(DiscountStrategy):
    def __init__(self, amount: int) -> None:
        self.amount = amount

    def is_applicable(self, product: Product, user_tier: str) -> bool:
        return product.price * 0.9 > self.amount

    def apply_discount(self, product: Product) -> float:
        return product.price - self.amount

class PremiumUserDiscount(DiscountStrategy):
    def is_applicable(self, product: Product, user_tier: str) -> bool:
        return user_tier.lower() == 'premium'

    def apply_discount(self, product: Product) -> float:
        return product.price * 0.8

class DiscountEngine:
    def __init__(self, strategies: List[DiscountStrategy]) -> None:
        self.strategies = strategies

    def calculate_best_price(self, product: Product, user_tier: str) -> float:
        prices = [product.price]

        for strategy in self.strategies:
            if strategy.is_applicable(product, user_tier):
                discounted = strategy.apply_discount(product)
                prices.append(discounted)
        return min(prices)

product = Product('Wireless Mouse', 50.0)

--fcc-editable-region--
print(product)

discount = PercentageDiscount(10)
print(discount.apply_discount(product))

fixed_discount = FixedAmountDiscount(5)
print(fixed_discount.apply_discount(product))
--fcc-editable-region--
```
