---
id: 6853f90fd03acc9fd75ff860
title: Step 46
challengeType: 20
dashedName: step-46
---

# --description--

Users should be able to check their inbox, read emails, and delete emails directly through their User object.

For checking the inbox, add a method called `check_inbox` to the `User` class. This method should print a personalized header with the user's name and then display all their emails.

The header should be formatted as: `\nName's Inbox:`, where `Name` is replaced with the name of the user.

After printing the header, call the `list_emails()` method on the user's inbox.

# --hints--

You should define a method named `check_inbox` in the `User` class that takes `self` as a parameter.

```js
({
    test: () => 
    {
        assert(runPython(`_Node(_code).find_class("User").find_function("check_inbox").has_args("self")`))
    }

})
```

Within `check_inbox`, you should print a header that includes the user's name in the format `\n[user]'s Inbox:`.

```js
({ 
    test: () => 
    {
        assert(runPython(`_Node(_code).find_class("User").find_function("check_inbox").find_body()[0].is_equivalent('print(f"\\\\n{self.name}\\\'s Inbox:")')`))
    }
})
```

Within `check_inbox`, you should call `self.inbox.list_emails()` to display the emails.

```js
({ 
    test: () => 
    {
        assert(runPython(`_Node(_code).find_class("User").find_function("check_inbox").find_body()[1].is_equivalent("self.inbox.list_emails()")`))
    }
})

```

# --seed--

## --seed-contents--

```py
import datetime

class Email:
    def __init__(self, sender, receiver, subject, body):
        self.sender = sender
        self.receiver = receiver
        self.subject = subject
        self.body = body
        self.timestamp = datetime.datetime.now()
        self.read = False

    def mark_as_read(self):
        self.read = True

    def display_full_email(self):
        self.mark_as_read()
        print('\n--- Email ---')
        print(f'From: {self.sender.name}')
        print(f'To: {self.receiver.name}')
        print(f'Subject: {self.subject}')
        print(f"Received: {self.timestamp.strftime('%Y-%m-%d %H:%M')}")
        print(f'Body: {self.body}')
        print('------------\n')

    def __str__(self):
        status = 'Read' if self.read else 'Unread'
        return f"[{status}] From: {self.sender.name} | Subject: {self.subject} | Time: {self.timestamp.strftime('%Y-%m-%d %H:%M')}"

class User:
    def __init__(self, name):
        self.name = name
        self.inbox = Inbox()

    def send_email(self, receiver, subject, body):
        email = Email(sender=self, receiver=receiver, subject=subject, body=body)
        receiver.inbox.receive_email(email)
        print(f'Email sent from {self.name} to {receiver.name}!\n')

--fcc-editable-region--
    
--fcc-editable-region--

class Inbox:
    def __init__(self):
        self.emails = []

    def receive_email(self, email):
        self.emails.append(email)

    def list_emails(self):
        if not self.emails:
            print('Your inbox is empty.\n')
            return
        print('\nYour Emails:')
        for i, email in enumerate(self.emails, start=1):
            print(f'{i}. {email}')

    def read_email(self, index):
        if not self.emails:
            print('Inbox is empty.\n')
            return
        actual_index = index - 1
        if actual_index < 0 or actual_index >= len(self.emails):
            print('Invalid email number.\n')
            return
        self.emails[actual_index].display_full_email()

    def delete_email(self, index):
        if not self.emails:
            print('Inbox is empty.\n')
            return
        actual_index = index - 1
        if actual_index < 0 or actual_index >= len(self.emails):
            print('Invalid email number.\n')
            return
        del self.emails[actual_index]
        print('Email deleted.\n')

```
