---
id: 6853f996671e63a0b4fbf143
title: Step 47
challengeType: 20
dashedName: step-47
---

# --description--

For reading and deleting emails, add two methods to your `User` class: `read_email` and `delete_email`. Both should take an `index` parameter and call the corresponding method on `self.inbox`.

# --hints--

You should define a method named `read_email` in the `User` class that takes `self` and `index` as parameters.

```js
({
    test: () => {
        assert(runPython(`_Node(_code).find_class("User").find_function("read_email").has_args("self, index")`));
    }
})
```

The `read_email` method should call `self.inbox.read_email(index)`.

```js
({
    test: () => {
        assert(runPython(`_Node(_code).find_class("User").find_function("read_email").has_call("self.inbox.read_email(index)")`));
    }
})
```

You should define a method named `delete_email` in the `User` class that takes `self` and `index` as parameters.

```js
({
    test: () => {
        assert(runPython(`_Node(_code).find_class("User").find_function("delete_email").has_args("self, index")`));
    }
})
```

The `delete_email` method should call `self.inbox.delete_email(index)`.

```js
({
    test: () => {
        assert(runPython(`_Node(_code).find_class("User").find_function("delete_email").has_call("self.inbox.delete_email(index)")`));
    }
})
```

# --seed--

## --seed-contents--

```py
import datetime

class Email:
    def __init__(self, sender, receiver, subject, body):
        self.sender = sender
        self.receiver = receiver
        self.subject = subject
        self.body = body
        self.timestamp = datetime.datetime.now()
        self.read = False

    def mark_as_read(self):
        self.read = True

    def display_full_email(self):
        self.mark_as_read()
        print('\n--- Email ---')
        print(f'From: {self.sender.name}')
        print(f'To: {self.receiver.name}')
        print(f'Subject: {self.subject}')
        print(f"Received: {self.timestamp.strftime('%Y-%m-%d %H:%M')}")
        print(f'Body: {self.body}')
        print('------------\n')

    def __str__(self):
        status = 'Read' if self.read else 'Unread'
        return f"[{status}] From: {self.sender.name} | Subject: {self.subject} | Time: {self.timestamp.strftime('%Y-%m-%d %H:%M')}"

class User:
    def __init__(self, name):
        self.name = name
        self.inbox = Inbox()

    def send_email(self, receiver, subject, body):
        email = Email(sender=self, receiver=receiver, subject=subject, body=body)
        receiver.inbox.receive_email(email)
        print(f'Email sent from {self.name} to {receiver.name}!\n')

    def check_inbox(self):
        print(f'\n{self.name}\'s Inbox:')
        self.inbox.list_emails()

--fcc-editable-region--
    
--fcc-editable-region--

class Inbox:
    def __init__(self):
        self.emails = []

    def receive_email(self, email):
        self.emails.append(email)

    def list_emails(self):
        if not self.emails:
            print('Your inbox is empty.\n')
            return
        print('\nYour Emails:')
        for i, email in enumerate(self.emails, start=1):
            print(f'{i}. {email}')

    def read_email(self, index):
        if not self.emails:
            print('Inbox is empty.\n')
            return
        actual_index = index - 1
        if actual_index < 0 or actual_index >= len(self.emails):
            print('Invalid email number.\n')
            return
        self.emails[actual_index].display_full_email()

    def delete_email(self, index):
        if not self.emails:
            print('Inbox is empty.\n')
            return
        actual_index = index - 1
        if actual_index < 0 or actual_index >= len(self.emails):
            print('Invalid email number.\n')
            return
        del self.emails[actual_index]
        print('Email deleted.\n')

```
