---
id: 685a82a54950823ef954276a
title: Step 48
challengeType: 20
dashedName: step-48
---

# --description--

Now you'll create the main function that demonstrates your email simulator.

Create the `main` function and inside it, using the `User` class, create two users: `Tory` and `Ramy` and assign them to variables `tory` and `ramy`, respectively. 

# --hints--

You should define a function named `main`.

```js
({
    test: () => 
    {
        assert(runPython(`_Node(_code).has_function("main")`))
    }

})
```

You should create a user named `Tory` and assign it to a variable called `tory`.

```js
({
    test: () => 
    {
        assert(runPython(`_Node(_code).find_function("main").find_variable("tory").is_equivalent("tory = User('Tory')")`))
    }

})
```

You should create a user named `Ramy` and assign it to a variable called `ramy`.

```js
({
    test: () => 
    {
        assert(runPython(`_Node(_code).find_function("main").find_variable("ramy").is_equivalent("ramy = User('Ramy')")`))
    }

})

```

# --seed--

## --seed-contents--

```py
import datetime

class Email:
    def __init__(self, sender, receiver, subject, body):
        self.sender = sender
        self.receiver = receiver
        self.subject = subject
        self.body = body
        self.timestamp = datetime.datetime.now()
        self.read = False

    def mark_as_read(self):
        self.read = True

    def display_full_email(self):
        self.mark_as_read()
        print('\n--- Email ---')
        print(f'From: {self.sender.name}')
        print(f'To: {self.receiver.name}')
        print(f'Subject: {self.subject}')
        print(f"Received: {self.timestamp.strftime('%Y-%m-%d %H:%M')}")
        print(f'Body: {self.body}')
        print('------------\n')

    def __str__(self):
        status = 'Read' if self.read else 'Unread'
        return f"[{status}] From: {self.sender.name} | Subject: {self.subject} | Time: {self.timestamp.strftime('%Y-%m-%d %H:%M')}"
class Inbox:
    def __init__(self):
        self.emails = []

    def receive_email(self, email):
        self.emails.append(email)

    def list_emails(self):
        if not self.emails:
            print('Your inbox is empty.\n')
            return
        print('\nYour Emails:')
        for i, email in enumerate(self.emails, start=1):
            print(f'{i}. {email}')


    def read_email(self, index):
        if not self.emails:
            print('Inbox is empty.\n')
            return
        actual_index = index - 1
        if actual_index < 0 or actual_index >= len(self.emails):
            print('Invalid email number.\n')
            return
        self.emails[actual_index].display_full_email()

    def delete_email(self, index):
        if not self.emails:
            print('Inbox is empty.\n')
            return
        actual_index = index - 1
        if actual_index < 0 or actual_index >= len(self.emails):
            print('Invalid email number.\n')
            return
        del self.emails[actual_index]
        print('Email deleted.\n')

class User:
    def __init__(self, name):
        self.name = name
        self.inbox = Inbox()

    def send_email(self, receiver, subject, body):
        email = Email(sender=self, receiver=receiver, subject=subject, body=body)
        receiver.inbox.receive_email(email)
        print(f'Email sent from {self.name} to {receiver.name}!\n')

    def check_inbox(self):
        print(f"\n{self.name}'s Inbox:")
        self.inbox.list_emails()

    def read_email(self, index):
        self.inbox.read_email(index)

    def delete_email(self, index):
        self.inbox.delete_email(index)

--fcc-editable-region--

--fcc-editable-region--
```
