---
id: 68be6a4447e61c4395ef2359
title: Step 36
challengeType: 20
dashedName: step-36
---

# --description--

Your inbox also needs a way to delete emails.

Python's `del` keyword can be used to delete items from a list by their index.

Add a method called `delete_email` to your `Inbox` class. Like `read_email`, it should:

- Take an `index` parameter, check for an empty inbox, and print the message `Inbox is empty.\n` if it is. Use `return` to exit the method.

# --hints--

You should define a method named `delete_email` in the `Inbox` class that takes `self` and `index` as parameters.

```js
({
    test: () => 
    {
        assert(runPython(`_Node(_code).find_class("Inbox").find_function("delete_email").has_args("self,index")`))
    }
})

```

You should check if the inbox is empty first using `if not self.emails:`. 

```js
({
    test: () => 
    {
        assert(runPython(`_Node(_code).find_class("Inbox").find_function("delete_email").find_ifs()[0].find_conditions()[0].is_equivalent("not self.emails")`))
    }
})

```

If inbox is empty, you should print the message `Inbox is empty.\n` and use `return` to exit the method.

```js
({
    test: () => 
    {
    assert(runPython(`_Node(_code).find_class("Inbox").find_function("delete_email").find_ifs()[0].find_body().is_equivalent("print('Inbox is empty.\\\\n')\\nreturn")`))
}
})
```

# --seed--

## --seed-contents--

```py
class Email:
    def __init__(self, sender, receiver, subject, body):
        self.sender = sender
        self.receiver = receiver
        self.subject = subject
        self.body = body
        self.read = False

    def mark_as_read(self):
        self.read = True

    def display_full_email(self):
        self.mark_as_read()
        print('\n--- Email ---')
        print(f'From: {self.sender.name}')
        print(f'To: {self.receiver.name}')
        print(f'Subject: {self.subject}')
        print(f'Body: {self.body}')
        print('------------\n')

    def __str__(self):
        status = 'Read' if self.read else 'Unread'
        return f"[{status}] From: {self.sender.name} | Subject: {self.subject}"
class User:
    def __init__(self, name):
        self.name = name
        self.inbox = Inbox()

    def send_email(self, receiver, subject, body):
        email = Email(sender=self, receiver=receiver, subject=subject, body=body)
        receiver.inbox.receive_email(email)

class Inbox:
    def __init__(self):
        self.emails = []

    def receive_email(self, email):
        self.emails.append(email)

    def list_emails(self):
        if not self.emails:
            print('Your inbox is empty.\n')
            return
        print('\nYour Emails:')
        for i, email in enumerate(self.emails, start=1):
            print(f'{i}. {email}')

    def read_email(self, index):
        if not self.emails:
            print('Inbox is empty.\n')
            return
        actual_index = index - 1
        if actual_index < 0 or actual_index >= len(self.emails):
            print('Invalid email number.\n')
            return
        self.emails[actual_index].display_full_email()
--fcc-editable-region--

--fcc-editable-region--
```
