---
id: 689b17e7e63b8e2c13839e98
title: Step 10
challengeType: 0
dashedName: step-10
---

# --description--

Now it's time to implement the actual counting functionality. 

Instead of just logging the current count, you need to increment it and update the display.

Remove the `console.log`.

Check if the current first number inside the `.count` is already 10 (the text is `10/10`), and if so, do nothing.

If the number is less than 10, increment the current count by 1 and update the text of the `.count` element. For example, if the current count is 2, it should be incremented to 3 and the text for the `.count` element should be `3/10`.

# --hints--

When the button is clicked, the count should increment from 0 to 1.

```js
const spy = __helpers.spyOn(console, "log");
const countEl = document.querySelector("#happy-btn .count");
countEl.textContent = "0/10";
document.querySelector("#happy-btn").click();
assert.equal(countEl.textContent, "1/10");
```

When the button is clicked multiple times, the count should increment properly.

```js
const countEl = document.querySelector("#happy-btn .count");
countEl.textContent = "3/10";
document.querySelector("#happy-btn").click();
assert.equal(countEl.textContent, "4/10");
```

When the count is already at 10, clicking should not increment it further.

```js
const countEl = document.querySelector("#happy-btn .count");
countEl.textContent = "10/10";
document.querySelector("#happy-btn").click();
assert.equal(countEl.textContent, "10/10");
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Emoji Reactor</title>
  <link rel="stylesheet" href="./styles.css" />
</head>
<body>
  <main>

    <h1 class="title">How are you feeling today?</h1>

    <p class="description">
      Click on the buttons below to rate your emotions.
    </p>
    <div class="btn-container">
      <button id="happy-btn" class="emoji-btn" aria-label="Happy face emoji">
        <span role="img" aria-hidden="true">😊</span>
        <span class="count">0/10</span>
      </button>
    </div>
  </main>
  <script src="./script.js"></script>
</body>
</html>
```

```css
*,
*::before,
*::after {
  box-sizing: border-box;
  margin: 0;
  padding: 0;
}

:root {
  --light-grey: #efefef;
  --white: #ffffff;
  --very-dark-blue: #0a0a23;
  --light-purple: #a78bfa;
  --very-light-purple: #c4b5fd;
  --purple: #8b5cf6;
}

body {
  background-color: var(--very-dark-blue);
  color: var(--light-grey);
  font-family: sans-serif;
}

main {
  text-align: center;
  padding: 10px;
}

.btn-container,
button {
  display: flex;
  justify-content: space-evenly;
  align-items: center;
}

.btn-container {
  flex-direction: column;
}

.emoji-btn {
  width: 70%;
  cursor: pointer;
  color: var(--white);
  background-color: var(--light-purple);
  background-image: linear-gradient(
    to bottom,
    var(--very-light-purple),
    var(--light-purple)
  );
  border: 3px solid var(--purple);
  border-radius: 8px;
  padding: 10px;
  font-size: 1.5rem;
  margin: 10px 0;
  transition: background-color 0.3s ease, transform 0.2s ease;
}

@media (min-width: 768px) {
  .emoji-btn {
    width: 30%;
  }
}

.emoji-btn:hover {
  background-color: var(--purple);
  background-image: none;
}

.title {
  margin-top: 15px;
  font-size: 2rem;
}

.description {
  font-size: 1.4rem;
  margin: 20px 0;
}
```

```js
--fcc-editable-region--
const happyBtn = document.querySelector("#happy-btn");

happyBtn.addEventListener("click", () => {
  const countEl = happyBtn.querySelector(".count");
  const currCount = +countEl.textContent.split("/")[0];
  console.log("Current count:", currCount);
})


--fcc-editable-region--
```
