---
id: 68a9fa161498c3324ac06fe1
title: Step 12
challengeType: 0
dashedName: step-12
---

# --description--

It's time to start working on the other buttons. The remaining `button` elements have been added for you in the HTML file.

For each new button (`#confused-btn`, `#sad-btn` and `#loving-btn`), select it using `querySelector` with its ID, then add a click event listener that calls `updateCount` with that button.

Use the variable names `confusedBtn`, `sadBtn`, `lovingBtn`.

# --hints--

You should create a variable named `confusedBtn`.

```js
assert.exists(confusedBtn);
```

You should store the `#confused-btn` element in the `confusedBtn` variable.

```js
assert.equal(confusedBtn, document.querySelector('#confused-btn'));
```

You should create a variable named `sadBtn`.

```js
assert.exists(sadBtn);
```

You should store the `#sad-btn` element in the `sadBtn` variable.

```js
assert.equal(sadBtn, document.querySelector('#sad-btn'));
```

You should create a variable named `lovingBtn`.

```js
assert.exists(lovingBtn);
```

You should store the `#loving-btn` element in the `lovingBtn` variable.

```js
assert.equal(lovingBtn, document.querySelector('#loving-btn'));
```

The `#confused-btn` element should have a click event listener that calls `updateCount`.

```js
const spy = __helpers.spyOn(window, "updateCount");
document.querySelector("#confused-btn").click();
assert.equal(spy.calls.length, 1);
assert.equal(spy.calls[0][0], document.querySelector("#confused-btn"));
```

The `#sad-btn` element should have a click event listener that calls `updateCount`.

```js
const spy = __helpers.spyOn(window, "updateCount");
document.querySelector("#sad-btn").click();
assert.equal(spy.calls.length, 1);
assert.equal(spy.calls[0][0], document.querySelector("#sad-btn"));
```

The `#loving-btn` element should have a click event listener that calls `updateCount`.

```js
const spy = __helpers.spyOn(window, "updateCount");
document.querySelector("#loving-btn").click();
assert.equal(spy.calls.length, 1);
assert.equal(spy.calls[0][0], document.querySelector("#loving-btn"));
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Emoji Reactor</title>
  <link rel="stylesheet" href="./styles.css" />
</head>
<body>
  <main>

    <h1 class="title">How are you feeling today?</h1>

    <p class="description">
      Click on the buttons below to rate your emotions.
    </p>
    <div class="btn-container">
      <button id="happy-btn" class="emoji-btn" aria-label="Happy face emoji">
        <span role="img" aria-hidden="true">😊</span>
        <span class="count">0/10</span>
      </button>
      <button
        id="confused-btn"
        class="emoji-btn"
        aria-label="Confused face emoji"
      >
        <span role="img" aria-hidden="true">😕</span>
        <span class="count">0/10</span>
      </button>
      <button id="sad-btn" class="emoji-btn" aria-label="Angry face emoji">
        <span role="img" aria-hidden="true">😠</span>
        <span class="count">0/10</span>
      </button>
      <button
        id="loving-btn"
        class="emoji-btn"
        aria-label="Loving face emoji"
      >
        <span role="img" aria-hidden="true">😍</span>
        <span class="count">0/10</span>
      </button>
    </div>
  </main>
  <script src="./script.js"></script>
</body>
</html>
```

```css
*,
*::before,
*::after {
  box-sizing: border-box;
  margin: 0;
  padding: 0;
}

:root {
  --light-grey: #efefef;
  --white: #ffffff;
  --very-dark-blue: #0a0a23;
  --light-purple: #a78bfa;
  --very-light-purple: #c4b5fd;
  --purple: #8b5cf6;
}

body {
  background-color: var(--very-dark-blue);
  color: var(--light-grey);
  font-family: sans-serif;
}

main {
  text-align: center;
  padding: 10px;
}

.btn-container,
button {
  display: flex;
  justify-content: space-evenly;
  align-items: center;
}

.btn-container {
  flex-direction: column;
}

.emoji-btn {
  width: 70%;
  cursor: pointer;
  color: var(--white);
  background-color: var(--light-purple);
  background-image: linear-gradient(
    to bottom,
    var(--very-light-purple),
    var(--light-purple)
  );
  border: 3px solid var(--purple);
  border-radius: 8px;
  padding: 10px;
  font-size: 1.5rem;
  margin: 10px 0;
  transition: background-color 0.3s ease, transform 0.2s ease;
}

@media (min-width: 768px) {
  .emoji-btn {
    width: 30%;
  }
}

.emoji-btn:hover {
  background-color: var(--purple);
  background-image: none;
}

.title {
  margin-top: 15px;
  font-size: 2rem;
}

.description {
  font-size: 1.4rem;
  margin: 20px 0;
}
```

```js
--fcc-editable-region--
function updateCount(btn) {
  const countEl = btn.querySelector(".count");
  let currCount = +countEl.textContent.split("/")[0];
  
  if (currCount === 10) return;
  
  currCount++;
  
  countEl.textContent = `${currCount}/10`;
}

const happyBtn = document.querySelector("#happy-btn");

happyBtn.addEventListener("click", () => updateCount(happyBtn));


--fcc-editable-region--
```
