---
id: 68a9fa1787009f3293b7ba7f
title: Step 13
challengeType: 0
dashedName: step-13
---

# --description--

You've probably noticed that your code is getting quite repetitive! There's a better way to handle multiple similar elements.

Instead of selecting each button individually, use `querySelectorAll(".emoji-btn")` to select all buttons with the class `emoji-btn` at once. Store the result in a variable called `btns`.

# --before-all--

```js
const loggedValues = [];
const originalConsoleLog = console.log;
console.log = (...args) => {
  loggedValues.push(args);
  originalConsoleLog(...args);
};
```

# --hints--

You should use `querySelectorAll` to select all emoji buttons.

```js
assert.match(code, /document\.querySelectorAll\s*\(\s*['"`]\.emoji-btn['"`]\s*\)/);
```

You should store the result in a variable called `btns`.

```js
assert.isDefined(btns, 'You should create a variable called btns');
assert.isTrue(btns instanceof NodeList, 'btns should be a NodeList from querySelectorAll');
```

The `btns` variable should contain all 4 emoji buttons.

```js
assert.equal(btns.length, 4, 'btns should contain all 4 emoji buttons');
assert.equal(btns[0].id, 'happy-btn', 'First button should be the happy button');
assert.equal(btns[1].id, 'confused-btn', 'Second button should be the confused button');
assert.equal(btns[2].id, 'sad-btn', 'Third button should be the sad button');
assert.equal(btns[3].id, 'loving-btn', 'Fourth button should be the loving button');
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Emoji Reactor</title>
  <link rel="stylesheet" href="./styles.css" />
</head>
<body>
  <main>

    <h1 class="title">How are you feeling today?</h1>

    <p class="description">
      Click on the buttons below to rate your emotions.
    </p>
    <div class="btn-container">
      <button id="happy-btn" class="emoji-btn" aria-label="Happy face emoji">
        <span role="img" aria-hidden="true">😊</span>
        <span class="count">0/10</span>
      </button>
      <button
        id="confused-btn"
        class="emoji-btn"
        aria-label="Confused face emoji"
      >
        <span role="img" aria-hidden="true">😕</span>
        <span class="count">0/10</span>
      </button>
      <button id="sad-btn" class="emoji-btn" aria-label="Angry face emoji">
        <span role="img" aria-hidden="true">😠</span>
        <span class="count">0/10</span>
      </button>
      <button
        id="loving-btn"
        class="emoji-btn"
        aria-label="Loving face emoji"
      >
        <span role="img" aria-hidden="true">😍</span>
        <span class="count">0/10</span>
      </button>
    </div>
  </main>
  <script src="./script.js"></script>
</body>
</html>
```

```css
*,
*::before,
*::after {
  box-sizing: border-box;
  margin: 0;
  padding: 0;
}

:root {
  --light-grey: #efefef;
  --white: #ffffff;
  --very-dark-blue: #0a0a23;
  --light-purple: #a78bfa;
  --very-light-purple: #c4b5fd;
  --purple: #8b5cf6;
}

body {
  background-color: var(--very-dark-blue);
  color: var(--light-grey);
  font-family: sans-serif;
}

main {
  text-align: center;
  padding: 10px;
}

.btn-container,
button {
  display: flex;
  justify-content: space-evenly;
  align-items: center;
}

.btn-container {
  flex-direction: column;
}

.emoji-btn {
  width: 70%;
  cursor: pointer;
  color: var(--white);
  background-color: var(--light-purple);
  background-image: linear-gradient(
    to bottom,
    var(--very-light-purple),
    var(--light-purple)
  );
  border: 3px solid var(--purple);
  border-radius: 8px;
  padding: 10px;
  font-size: 1.5rem;
  margin: 10px 0;
  transition: background-color 0.3s ease, transform 0.2s ease;
}

@media (min-width: 768px) {
  .emoji-btn {
    width: 30%;
  }
}

.emoji-btn:hover {
  background-color: var(--purple);
  background-image: none;
}

.title {
  margin-top: 15px;
  font-size: 2rem;
}

.description {
  font-size: 1.4rem;
  margin: 20px 0;
}
```

```js
--fcc-editable-region--
function updateCount(btn) {
  const countEl = btn.querySelector(".count");
  let currCount = +countEl.textContent.split("/")[0];
  
  if (currCount === 10) return;
  
  currCount++;
  
  countEl.textContent = `${currCount}/10`;
}

const happyBtn = document.querySelector("#happy-btn");
const confusedBtn = document.querySelector("#confused-btn");
const sadBtn = document.querySelector("#sad-btn");
const lovingBtn = document.querySelector("#loving-btn");

happyBtn.addEventListener("click", () => updateCount(happyBtn));
confusedBtn.addEventListener("click", () => updateCount(confusedBtn));
sadBtn.addEventListener("click", () => updateCount(sadBtn));
lovingBtn.addEventListener("click", () => updateCount(lovingBtn));


--fcc-editable-region--
```
