---
id: 641da42481d90c4314c99e94
title: Step 3
challengeType: 0
dashedName: step-3
---

# --description--

The `fetch()` method returns a `Promise`, which is a placeholder object that will either be fulfilled if your request is successful, or rejected if your request is unsuccessful.

If the `Promise` is fulfilled, it resolves to a `Response` object, and you can use the `.then()` method to access the `Response`.

Here's how you can chain `.then()` to the `fetch()` method:

```js
fetch("sample-url-goes-here")
  .then((res) => res)
```

Chain the `.then()` method to your `fetch` call. Inside the `.then()` method, add a callback function with `res` as a parameter, then log the `res` to the console so you can see the `Response` object. Open your browser console and expand the `Response` object to see what it contains.

Again, don't terminate the code with a semicolon yet.

# --before-all--

```js
window.fetch = () => Promise.resolve({json: () => Promise.resolve([{ author: 'Whoever', image: 'data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==', url: "http://not-a-real-url.nowhere/", bio: 'words go here' }])});
```

# --hints--

You should use the `fetch()` method to make a `GET` request to `"https://cdn.freecodecamp.org/curriculum/news-author-page/authors.json"`.

```js
assert.match(code, /fetch\(\s*('|"|`)https:\/\/cdn\.freecodecamp\.org\/curriculum\/news\-author\-page\/authors\.json\1\s*\)/)
```

You should chain the `.then()` method to your `fetch()` syntax

```js
assert.match(code, /fetch\(\s*('|"|`)https:\/\/cdn\.freecodecamp\.org\/curriculum\/news\-author\-page\/authors\.json\1\s*\)\s*\.then\(/)
```

You should add a `res` parameter to your `.then()` method.

```js
assert.match(code, /fetch\(\s*('|"|`)https:\/\/cdn\.freecodecamp\.org\/curriculum\/news\-author\-page\/authors\.json\1\s*\)\s*\.then\(\s*(\(\s*res\s*\)|res)/)
```

Your `.then()` method should use arrow function syntax.

```js
assert.match(code, /fetch\(\s*('|"|`)https:\/\/cdn\.freecodecamp\.org\/curriculum\/news\-author\-page\/authors\.json\1\s*\)\s*\.then\(\s*(\(\s*res\s*\)|res)\s*=>\s*/)
```

You should log the `res` parameter to the console so you can see the `Response` object.

```js
assert.match(code, /fetch\(\s*('|"|`)https:\/\/cdn\.freecodecamp\.org\/curriculum\/news\-author\-page\/authors\.json\1\s*\)\s*\.then\(\s*(\(\s*res\s*\)|res)\s*=>\s*console\.log\(\s*res\s*\)\s*\)/)
```

You should not have a semicolon after your `.then()`.

```js
assert.notMatch(code, /fetch\(\s*('|"|`)https:\/\/cdn\.freecodecamp\.org\/curriculum\/news\-author\-page\/authors\.json\1\s*\)\s*\.then\(\s*(\(\s*res\s*\)|res)\s*=>\s*console\.log\(\s*res\s*\)\s*\)\s*;/)
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>freeCodeCamp News Author Page</title>
    <link rel="stylesheet" href="./styles.css" />
  </head>
  <body>
    <h1 class="title">freeCodeCamp News Author Page</h1>

    <main>
      <div id="author-container"></div>
      <button class="btn" id="load-more-btn">Load More Authors</button>
    </main>

    <script src="./script.js"></script>
  </body>
</html>
```

```css
* {
  margin: 0;
  padding: 0;
  box-sizing: border-box;
}

:root {
  --main-bg-color: #1b1b32;
  --light-grey: #f5f6f7;
  --dark-purple: #5a01a7;
  --golden-yellow: #feac32;
}

body {
  background-color: var(--main-bg-color);
  text-align: center;
}

.title {
  color: var(--light-grey);
  margin: 20px 0;
}

#author-container {
  display: flex;
  flex-wrap: wrap;
  justify-content: center;
}

.user-card {
  border-radius: 15px;
  width: 300px;
  height: 350px;
  background-color: var(--light-grey);
  margin: 20px;
}

.user-img {
  width: 150px;
  height: 150px;
  object-fit: cover;
}

.purple-divider {
  background-color: var(--dark-purple);
  width: 100%;
  height: 15px;
}

.author-name {
  margin: 10px;
}

.bio {
  margin: 20px;
}

.error-msg {
  color: var(--light-grey);
}

.btn {
  cursor: pointer;
  width: 200px;
  margin: 10px;
  color: var(--main-bg-color);
  font-size: 14px;
  background-color: var(--golden-yellow);
  background-image: linear-gradient(#fecc4c, #ffac33);
  border-color: var(--golden-yellow);
  border-width: 3px;
}
```

```js
const authorContainer = document.getElementById('author-container');
const loadMoreBtn = document.getElementById('load-more-btn');

--fcc-editable-region--
fetch('https://cdn.freecodecamp.org/curriculum/news-author-page/authors.json')

--fcc-editable-region--
```
