---
id: 641da5abaac81844a54adb03
title: Step 8
challengeType: 0
dashedName: step-8
---

# --description--

Now, it is time to create the function that will be responsible for displaying the authors on the page. 

Start by creating a function called `displayAuthors` that takes an `authors` parameter. Your function should then loop through the `authors` array and add a card for each author to the `#authorContainer` element. 

The card should have the following structure:

```html
<div id="${index}" class="user-card">
  <h2 class="author-name">${author}</h2>
</div>
```

**Tips:**

- You can use any type of loop to iterate over the `authors` array. Ex. `for`, `forEach`, `map`, etc.
- You should use the `innerHTML` property to add the card to the `authorContainer` inside the loop. You will also need to use template literal syntax to add the markup.

# --before-all--

```js
window.fetch = () => Promise.resolve({json: () => Promise.resolve([{ author: 'Whoever', image: 'data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==', url: "http://not-a-real-url.nowhere/", bio: 'words go here' }])});
```

# --hints--

`displayAuthors` should be a function.

```js
assert.isFunction(displayAuthors)
```

Your `displayAuthors` function should take an `authors` parameter.

```js
const parameters = __helpers.getFunctionParams(displayAuthors.toString());
assert.deepEqual(parameters[0].name,"authors"); 
```

When the `displayAuthors` function is called with an author's array, it should add a card for each author to the `#authorContainer` element.

```js
const exampleAuthors = [
    [{
        "author": "Quincy Larson",
    }, {
        "author": "Jessica Wilkins",
    }, ],
    [{
        "author": "Naomi Carrigan",
    }, {
        "author": "Beau Carnes",
    }, {
        "author": "David Clinton",
    }],
];

for (const authorSet of exampleAuthors) {
    displayAuthors(authorSet);

    const authorCards = document.querySelectorAll("#author-container div");
    const authorTitles = document.querySelectorAll("#author-container div h2");
    assert.deepEqual(authorCards.length, authorTitles.length);
    for (let i = 0; i < authorCards.length; i++) {
        assert.deepEqual(authorCards[i].className, "user-card");
        assert.deepEqual(authorCards[i].id, i.toString());
        assert.deepEqual(authorTitles[i].className, "author-name");
        assert.deepEqual(authorTitles[i].innerText, authorSet[i].author);
    }
    authorContainer.innerHTML = "";
}
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>freeCodeCamp News Author Page</title>
    <link rel="stylesheet" href="./styles.css" />
  </head>
  <body>
    <h1 class="title">freeCodeCamp News Author Page</h1>

    <main>
      <div id="author-container"></div>
      <button class="btn" id="load-more-btn">Load More Authors</button>
    </main>

    <script src="./script.js"></script>
  </body>
</html>
```

```css
* {
  margin: 0;
  padding: 0;
  box-sizing: border-box;
}

:root {
  --main-bg-color: #1b1b32;
  --light-grey: #f5f6f7;
  --dark-purple: #5a01a7;
  --golden-yellow: #feac32;
}

body {
  background-color: var(--main-bg-color);
  text-align: center;
}

.title {
  color: var(--light-grey);
  margin: 20px 0;
}

#author-container {
  display: flex;
  flex-wrap: wrap;
  justify-content: center;
}

.user-card {
  border-radius: 15px;
  width: 300px;
  height: 350px;
  background-color: var(--light-grey);
  margin: 20px;
}

.user-img {
  width: 150px;
  height: 150px;
  object-fit: cover;
}

.purple-divider {
  background-color: var(--dark-purple);
  width: 100%;
  height: 15px;
}

.author-name {
  margin: 10px;
}

.bio {
  margin: 20px;
}

.error-msg {
  color: var(--light-grey);
}

.btn {
  cursor: pointer;
  width: 200px;
  margin: 10px;
  color: var(--main-bg-color);
  font-size: 14px;
  background-color: var(--golden-yellow);
  background-image: linear-gradient(#fecc4c, #ffac33);
  border-color: var(--golden-yellow);
  border-width: 3px;
}
```

```js
const authorContainer = document.getElementById('author-container');
const loadMoreBtn = document.getElementById('load-more-btn');

let startingIndex = 0;
let endingIndex = 8;
let authorDataArr = [];

fetch('https://cdn.freecodecamp.org/curriculum/news-author-page/authors.json')
  .then((res) => res.json())
  .then((data) => {
    console.log(data);   
  })
  .catch((err) => {
    console.error(`There was an error: ${err}`);
  });

--fcc-editable-region--

--fcc-editable-region--
```
