---
id: 67ec4a95b609c071f7747be0
title: Step 3
challengeType: 0
dashedName: step-3
---

# --description--

Inside the `form` element, add a `label` element. Your `label` element should have the text `Search for fruits:` and an `htmlFor` attribute with the value of `"search-input"`.

# --hints--

You should have a `label` element inside the `form` element.

```js
const form = document.querySelector("form");
assert.exists(form);

const label = form.querySelector("label");
assert.exists(label);
assert.strictEqual(label.tagName, "LABEL");
```

The `label` element should have an `htmlFor` attribute with the value of `"search-input"`.

```js
const label = document.querySelector("form label");
assert.exists(label);

const key = Object.keys(label).find(key => key.startsWith("__reactProps"));
const reactInstance = label[key]
assert.exists(reactInstance);

assert.equal(reactInstance.htmlFor, "search-input");
```

Your `label` element should have the text `Search for fruits:`.

```js
const label = document.querySelector("form label");
assert.exists(label);
assert.match(label.textContent.trim(), /^Search for fruits:$/);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8" />
  <title>Fruits Search</title>
   <script src="https://cdnjs.cloudflare.com/ajax/libs/react/18.3.1/umd/react.development.min.js"></script>
   <script src="https://cdnjs.cloudflare.com/ajax/libs/react-dom/18.3.1/umd/react-dom.development.min.js"></script>
   <script src="https://cdnjs.cloudflare.com/ajax/libs/babel-standalone/7.26.5/babel.min.js"></script>
  <script 
    data-plugins="transform-modules-umd"
    type="text/babel"
    src="index.jsx"
  ></script>
  <link rel="stylesheet" href="styles.css" />
</head>
<body>
  <div id="root"></div>
  <script
    data-plugins="transform-modules-umd"
    type="text/babel"
    data-presets="react"
    data-type="module"
  >
    import { FruitsSearch } from './index.jsx';
    ReactDOM.createRoot(document.getElementById('root')).render(<FruitsSearch />);
  </script>
</body>
</html>
```

```css
body {
  font-family: Arial, sans-serif;
  display: flex;
  justify-content: center;
  align-items: center;
  height: 100vh;
  background-color: #f4f4f4;
}

#search-container {
  text-align: center;
  background: white;
  padding: 20px;
  border-radius: 10px;
  box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
}

#search-input {
  padding: 10px;
  width: 80%;
  border: 1px solid #ccc;
  border-radius: 5px;
  margin-bottom: 10px;
}

#results {
  text-align: left;
  max-height: 150px;
  overflow-y: auto;
}
.result-item {
  padding: 5px;
  border-bottom: 1px solid #ddd;
}
```

```jsx
const { useState, useEffect } = React;

export function FruitsSearch() {
  
  return (
    --fcc-editable-region--
    <div id="search-container">
      <form>
        
      </form>
    </div>
    --fcc-editable-region--
  );
}
```
