---
id: 68e9a73075dc26207320811a
title: Step 11
challengeType: 0
dashedName: step-11
---

# --description--

Now that you can see your checkbox again, you are going to finalize some styling options for it. Give them a rounded edge by adding a `border-radius` of `4px` to your `input[type="checkbox"]` selector.

Then give it a `background-color` of `white` to make the center of your checkbox stand out from the background of the container.

Since you are going to be setting up a custom transition for when a user clicks on the checkboxes, set a `transition` with the value of `all` and `0.3s` so that the transition happens smoothly over 0.3 seconds rather than instantly.

# --hints--

You should add a `border-radius` property to your `input[type="checkbox"]` selector.

```js
assert.isNotEmpty(new __helpers.CSSHelp(document).getStyle('input[type="checkbox"]')?.borderRadius);
```

You should have a `border-radius` property with a value of `4px`.

```js
assert.strictEqual(new __helpers.CSSHelp(document).getStyle('input[type="checkbox"]')?.borderRadius, "4px");
```

You should add a `background-color` property to your `input[type="checkbox"]` selector.

```js
assert.isNotEmpty(new __helpers.CSSHelp(document).getStyle('input[type="checkbox"]')?.backgroundColor);
```

You should have a `background-color` property with a value of `white`.

```js
assert.oneOf(new __helpers.CSSHelp(document).getStyle('input[type="checkbox"]')?.backgroundColor, ["white", "rgb(255,255,255)", "#ffffff"]);
```

You should add a `transition` property to your `input[type="checkbox"]` selector.

```js
assert.isNotEmpty(new __helpers.CSSHelp(document).getStyle('input[type="checkbox"]')?.transition);
```

You should have `transition` with a value of `all 0.3s`.

```js
/**
 * Because CSS is simply the most lovely thing to ever exist, the behaviour of the `all` shorthand does wonky things and will not show up
 * in the computed stylesheet. Instead, we need to query the actual style element and extract the selector, checking the properties as written
 * by the camper.
 * I really hate CSS.
 * <3 Naomi
 */
const { props } = document.querySelector('.fcc-injected-styles')?.innerText?.match(/input\[type=('|")checkbox\1\]\s*\{(?<props>.*)\}/s)?.groups;
assert.match(props, /transition\s*\:\s*all\s+0.3\s*/);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Game Settings Panel</title>
    <link rel="stylesheet" href="styles.css" />
  </head>
  <body>
    <div class="settings-card">
      <h1>Game Settings</h1>
      <label> <input type="checkbox" />Sound Effects</label>
      <label> <input type="checkbox" />Background Music</label>
      <label> <input type="checkbox" />Hard Mode</label>
      <label> <input type="checkbox" />Haptic feedback</label>
    </div>
  </body>
</html>
```

```css
body {
  height: 100vh;
  background-color: #f0f0f0;
  text-align: center;
}

.settings-card {
  max-width: 250px;
  padding: 20px;
  border-radius: 10px;
  box-shadow: 0 2px 6px rgba(0, 0, 0, 0.2);
  margin: auto;
  text-align: left;
}

h1 {
  text-align: center;
}

label {
  display: block;
  cursor: pointer;
  margin: 8px auto;
}

input[type='checkbox'] {
  width: 20px;
  height: 20px;
  cursor: pointer;
  appearance: none;
  border: 2px solid #f1be32;
--fcc-editable-region--

--fcc-editable-region--
}
```
