---
id: 688ace81e3fb5a95a1f04c55
title: Step 22
challengeType: 20
dashedName: step-22
---

# --description--

Next, create an `else` block that assigns `current_node.next` to `self.head`.

This handles the case where the element to be removed is found in the head node. By updating `self.head` to point to `current_node.next`, the head node is removed from the linked list.

# --hints--

You should create an `else` block that assigns `current_node.next` to `self.head`.

```js
({ test: () => runPython(`
_cond = _Node(_code).find_class("LinkedList").find_function("remove").find_ifs()[0]
assert _cond.is_equivalent("if current_node is None:\\n return\\nelif previous_node is not None:\\n previous_node.next = current_node.next\\nelse:\\n self.head = current_node.next")
`) })
```

# --seed--

## --seed-contents--

```py
class LinkedList:
    class Node:
        def __init__(self, element):
            self.element = element
            self.next = None
            
    def __init__(self):
        self.length = 0
        self.head = None

    def is_empty(self):
        return self.length == 0
    
    def add(self, element):
        node = self.Node(element)
        if self.is_empty():
            self.head = node
        else:
            current_node = self.head
            while current_node.next is not None:
                current_node = current_node.next
            current_node.next = node
        self.length += 1

    def remove(self, element):
        previous_node = None
        current_node = self.head
        while current_node is not None and current_node.element != element:
            previous_node = current_node
            current_node = current_node.next
--fcc-editable-region--
        if current_node is None:
            return        
        elif previous_node is not None:
            previous_node.next = current_node.next
--fcc-editable-region--

my_list = LinkedList()
print(my_list.is_empty())

my_list.add(1)
my_list.add(2)
print(my_list.is_empty())
print(my_list.length)
```
