---
id: 68b6d1f70fffb10287c8031e
title: Step 15
challengeType: 20
dashedName: step-15
---

# --description--

Create another variable named `movie2` and assign it a `Movie` object instantiated with arguments of your choice. Then append `movie2` to the catalogue.

# --hints--

You should have a variable named `movie2`.

```js
({
  test: () => runPython(`assert _Node(_code).find_trys()[0].find_body().has_variable("movie2")`)
})
```

You should assign an instance of `Movie` to the `movie2` variable.

```js
({
    test: () => runPython(`
    assert isinstance(movie2, Movie)
    `)
})
```

You should have `catalogue.add(movie2)` in your `try` block.

```js
({
    test: () => runPython(`assert _Node(_code).find_trys()[0].find_body().has_stmt("catalogue.add(movie2)")`)
})
```

# --seed--

## --seed-contents--

```py
class Movie:
    def __init__(self, title, year, director, duration):
        if not title.strip():
            raise ValueError('Title cannot be empty')
        if year < 1895:
            raise ValueError('Year must be 1895 or later')
        if not director.strip():
            raise ValueError('Director cannot be empty')
        if duration <= 0:
            raise ValueError('Duration must be positive')
        self.title = title
        self.year = year
        self.director = director
        self.duration = duration

    def __str__(self):
        return f'{self.title} ({self.year}) - {self.duration} min, {self.director}'

class MediaCatalogue:
    def __init__(self):
        self.items = []

    def add(self, media_item):
        self.items.append(media_item)

    def __str__(self):
        if not self.items:
            return 'Media Catalogue (empty)'

        result = f'Media Catalogue ({len(self.items)} items):\n\n'
        
        for i, movie in enumerate(self.items, 1):
            result += f'{i}. {movie}\n'
        return result

catalogue = MediaCatalogue()

try:
--fcc-editable-region--
    movie1 = Movie('The Matrix', 1999, 'The Wachowskis', 136)
    catalogue.add(movie1)
    
--fcc-editable-region--
    print(catalogue)
except ValueError as e:
    print(f'Validation Error: {e}')
```
