---
id: 68b7e1818bd294974b9099bf
title: Step 13
challengeType: 20
dashedName: step-13
---

# --description--

Right after declaring the `result` variable, create a `for` loop that uses enumeration to iterate over the items in the catalogue and appends to `result` a string with the following format: `N. movie` where `N` is a numeric index starting from `1` and `movie` is the string representation of the item.

Make the string end with a newline character and return `result` after the loop.

# --hints--

You should have a `for` loop in your `__str__` method.

```js
({
  test: () => runPython(`assert _Node(_code).find_class("MediaCatalogue").find_function("__str__").find_for_loops()[0]`)
})
```

Your `for` loop should use the `enumerate` function.

```js
({
  test: () => runPython(`assert "enumerate(" in str(_Node(_code).find_class("MediaCatalogue").find_function("__str__").find_for_loops()[0].find_for_iter())`)
})
```

Your `__str__` method should return `result`.

```js
({
  test: () => runPython(`assert _Node(_code).find_class("MediaCatalogue").find_function("__str__").has_return("result")`)
})
```

When `self.items` contains `Movie('Dances with Wolves', 1990, 'Kevin Costner', 224)` and `Movie('Annie Hall', 1977, 'Woody Allen', 93)`, your `__str__` method should return `Media Catalogue (2 items):\n\n1. Dances with Wolves (1990) - 224 min, Kevin Costner\n2. Annie Hall (1977) - 93 min, Woody Allen\n`.

```js
({
  test: () => runPython(`
    import io
    import sys
        
    captured_output = io.StringIO()
    sys.stdout = captured_output

    _catalogue = MediaCatalogue()
    _catalogue.add(Movie('Dances with Wolves', 1990, 'Kevin Costner', 224))
    _catalogue.add(Movie('Annie Hall', 1977, 'Woody Allen', 93))
    print(_catalogue)
        
    sys.stdout = sys.__stdout__
    output = captured_output.getvalue()

    _expected = """Media Catalogue (2 items):

    1. Dances with Wolves (1990) - 224 min, Kevin Costner
    2. Annie Hall (1977) - 93 min, Woody Allen
    """
    assert _expected in output
  `)
})
```

When `self.items` contains `Movie('Barry Lyndon', 1975, 'Stanley Kubrick', 184)` and `Movie('Fahrenheit 451', 1966, 'Francois Truffaut', 112)`, your `__str__` method should return `Media Catalogue (2 items):\n\n1. Barry Lyndon (1975) - 184 min, Stanley Kubrick\n2. Fahrenheit 451 (1966) - 112 min, Francois Truffaut\n`.

```js
({
  test: () => runPython(`
    import io
    import sys
        
    captured_output = io.StringIO()
    sys.stdout = captured_output

    _catalogue = MediaCatalogue()
    _catalogue.add(Movie('Barry Lyndon', 1975, 'Stanley Kubrick', 184))
    _catalogue.add(Movie('Fahrenheit 451', 1966, 'Francois Truffaut', 112))
    print(_catalogue)
        
    sys.stdout = sys.__stdout__
    output = captured_output.getvalue()

    _expected = """Media Catalogue (2 items):

    1. Barry Lyndon (1975) - 184 min, Stanley Kubrick
    2. Fahrenheit 451 (1966) - 112 min, Francois Truffaut
    """
    assert _expected in output
  `)
})
```

Your `__str__` method should return `Media Catalogue (empty)` when `self.items` is empty.

```js
({
  test: () => runPython(`
    import io
    import sys
        
    captured_output = io.StringIO()
    sys.stdout = captured_output
        
    print(MediaCatalogue())
        
    sys.stdout = sys.__stdout__
    output = captured_output.getvalue()
        
    assert "Media Catalogue (empty)" in output
  `)
})
```

# --seed--

## --seed-contents--

```py
class Movie:
    def __init__(self, title, year, director, duration):
        if not title.strip():
            raise ValueError('Title cannot be empty')
        if year < 1895:
            raise ValueError('Year must be 1895 or later')
        if not director.strip():
            raise ValueError('Director cannot be empty')
        if duration <= 0:
            raise ValueError('Duration must be positive')
        self.title = title
        self.year = year
        self.director = director
        self.duration = duration

    def __str__(self):
        return f'{self.title} ({self.year}) - {self.duration} min, {self.director}'

class MediaCatalogue:
    def __init__(self):
        self.items = []

    def add(self, media_item):
        self.items.append(media_item)
--fcc-editable-region--
    def __str__(self):
        if not self.items:
            return 'Media Catalogue (empty)'
        result = f'Media Catalogue ({len(self.items)} items):\n\n'
        
--fcc-editable-region--
try:
    movie1 = Movie('The Matrix', 1999, 'The Wachowskis', 136)
except ValueError as e:
    print(f'Validation Error: {e}')
```
