---
id: 68b80a995417adac579f9545
title: Step 19
challengeType: 20
dashedName: step-19
---

# --description--

Now, complete your `__init__` method by validating `seasons` and `total_episodes`. Create an `if` statement that checks if `seasons` is less than `1` and raises a `ValueError` with the message `Seasons must be 1 or greater`.

Then, do the same to validate `total_episodes`. This time use the message `Total episodes must be 1 or greater`.

# --hints--

You should raise a `ValueError` with the message `Seasons must be 1 or greater` when `seasons` is less than `1`.

```js
({
  test: () => runPython(`
  _msg = 'Seasons must be 1 or greater'
  _expected_error = f"Expected to raise 'ValueError: {_msg}'"
  try:
    TVSeries('Scrubs', 2001, 'Bill Lawrence', 24, 0, 182)
  except ValueError as e:
    assert str(e) == _msg
  else:
    assert False, _expected_error

  try:
    TVSeries('Scrubs', 2001, 'Bill Lawrence', 24, -1, 182)
  except ValueError as e:
    assert str(e) == _msg
  else:
    assert False, _expected_error
  `)
})
```

You should not raise a `ValueError` when `seasons` is a valid number.

```js
({
    test: () => runPython(`
    try:
      TVSeries('Scrubs', 2001, 'Bill Lawrence', 24, 1, 182)
    except ValueError:
      assert False, 'Expected not to raise a ValueError with valid seasons'
    `)
})
```

You should raise a `ValueError` with the message `Total episodes must be 1 or greater` when `total_episodes` is less than `1`.

```js
({
  test: () => runPython(`
  _msg = 'Total episodes must be 1 or greater'
  _expected_error = f"Expected to raise 'ValueError: {_msg}'"
  try:
    TVSeries('Scrubs', 2001, 'Bill Lawrence', 24, 9, 0)
  except ValueError as e:
    assert str(e) == _msg
  else:
    assert False, _expected_error

  try:
    TVSeries('Scrubs', 2001, 'Bill Lawrence', 24, 9, -1)
  except ValueError as e:
    assert str(e) == _msg
  else:
    assert False, _expected_error
  `)
})
```

You should not raise a `ValueError` when `total_episodes` is a valid number.

```js
({
    test: () => runPython(`
    try:
      TVSeries('Scrubs', 2001, 'Bill Lawrence', 24, 9, 1)
    except ValueError:
      assert False, 'Expected not to raise a ValueError with valid total_episodes'
    `)
})
```

# --seed--

## --seed-contents--

```py
class Movie:
    def __init__(self, title, year, director, duration):
        if not title.strip():
            raise ValueError('Title cannot be empty')
        if year < 1895:
            raise ValueError('Year must be 1895 or later')
        if not director.strip():
            raise ValueError('Director cannot be empty')
        if duration <= 0:
            raise ValueError('Duration must be positive')
        self.title = title
        self.year = year
        self.director = director
        self.duration = duration

    def __str__(self):
        return f'{self.title} ({self.year}) - {self.duration} min, {self.director}'

class TVSeries(Movie):
    def __init__(self, title, year, director, duration, seasons, total_episodes):
        super().__init__(title, year, director, duration)
--fcc-editable-region--
        

        self.seasons = seasons
        self.total_episodes = total_episodes
--fcc-editable-region--
class MediaCatalogue:
    def __init__(self):
        self.items = []

    def add(self, media_item):
        self.items.append(media_item)

    def __str__(self):
        if not self.items:
            return 'Media Catalogue (empty)'

        result = f'Media Catalogue ({len(self.items)} items):\n\n'
        
        for i, movie in enumerate(self.items, 1):
            result += f'{i}. {movie}\n'
        return result

catalogue = MediaCatalogue()

try:
    movie1 = Movie('The Matrix', 1999, 'The Wachowskis', 136)
    catalogue.add(movie1)
    movie2 = Movie('Inception', 2010, 'Christopher Nolan', 148)
    catalogue.add(movie2)
    print(catalogue)
except ValueError as e:
    print(f'Validation Error: {e}')
```
