---
id: 68b80d521177c1e5469d31bf
title: Step 20
challengeType: 20
dashedName: step-20
---

# --description--

Now that the `__init__` method is complete, create a variable named `series1` inside the `try` block. Assign it an instance of `TVSeries` passing in arguments of your choice. Then, print `series1` to the console.

# --hints--

You should assign an instance of `TVSeries` to a variable named `series1` within the `try` block.

```js
({
    test: () => runPython(`
    assert _Node(_code).find_trys()[0].find_body().has_variable("series1")
    assert isinstance(series1, TVSeries)
    `)
})
```

You should print `series1` within the `try` block.

```js
({
    test: () => runPython(`
    assert _Node(_code).find_trys()[0].find_body().has_stmt("print(series1)")
    `)
})
```

# --seed--

## --seed-contents--

```py
class Movie:
    def __init__(self, title, year, director, duration):
        if not title.strip():
            raise ValueError('Title cannot be empty')
        if year < 1895:
            raise ValueError('Year must be 1895 or later')
        if not director.strip():
            raise ValueError('Director cannot be empty')
        if duration <= 0:
            raise ValueError('Duration must be positive')
        self.title = title
        self.year = year
        self.director = director
        self.duration = duration

    def __str__(self):
        return f'{self.title} ({self.year}) - {self.duration} min, {self.director}'

class TVSeries(Movie):
    def __init__(self, title, year, director, duration, seasons, total_episodes):
        super().__init__(title, year, director, duration)

        if seasons < 1:
            raise ValueError('Seasons must be 1 or greater')
        if total_episodes < 1:
            raise ValueError('Total episodes must be 1 or greater')
        
        self.seasons = seasons
        self.total_episodes = total_episodes


class MediaCatalogue:
    def __init__(self):
        self.items = []

    def add(self, media_item):
        self.items.append(media_item)

    def __str__(self):
        if not self.items:
            return 'Media Catalogue (empty)'

        result = f'Media Catalogue ({len(self.items)} items):\n\n'
        
        for i, movie in enumerate(self.items, 1):
            result += f'{i}. {movie}\n'
        return result

catalogue = MediaCatalogue()
--fcc-editable-region--
try:
    movie1 = Movie('The Matrix', 1999, 'The Wachowskis', 136)
    catalogue.add(movie1)
    movie2 = Movie('Inception', 2010, 'Christopher Nolan', 148)
    catalogue.add(movie2)
    

--fcc-editable-region--
    print(catalogue)
except ValueError as e:
    print(f'Validation Error: {e}')
```
