---
id: 68b80ef5aae8b2078b0a9dc1
title: Step 21
challengeType: 20
dashedName: step-21
---

# --description--

As you can see, `series1` is displayed in the same format of a `Movie` object because it's inheriting its parent's `__str__` method. In the next step, you'll override the `__str__` method to provide a custom string representation.

For now, delete the `print(series1)` line from your code.

# --hints--

You should not have `print(series1)` in your code

```js
({
    test: () => runPython(`
    assert not _Node(_code).find_trys()[0].find_body().has_stmt("print(series1)")
    `)
})
```

# --seed--

## --seed-contents--

```py
class Movie:
    def __init__(self, title, year, director, duration):
        if not title.strip():
            raise ValueError('Title cannot be empty')
        if year < 1895:
            raise ValueError('Year must be 1895 or later')
        if not director.strip():
            raise ValueError('Director cannot be empty')
        if duration <= 0:
            raise ValueError('Duration must be positive')
        self.title = title
        self.year = year
        self.director = director
        self.duration = duration

    def __str__(self):
        return f'{self.title} ({self.year}) - {self.duration} min, {self.director}'

class TVSeries(Movie):
    def __init__(self, title, year, director, duration, seasons, total_episodes):
        super().__init__(title, year, director, duration)

        if seasons < 1:
            raise ValueError('Seasons must be 1 or greater')
        if total_episodes < 1:
            raise ValueError('Total episodes must be 1 or greater')
        
        self.seasons = seasons
        self.total_episodes = total_episodes


class MediaCatalogue:
    def __init__(self):
        self.items = []

    def add(self, media_item):
        self.items.append(media_item)

    def __str__(self):
        if not self.items:
            return 'Media Catalogue (empty)'

        result = f'Media Catalogue ({len(self.items)} items):\n\n'
        
        for i, movie in enumerate(self.items, 1):
            result += f'{i}. {movie}\n'
        return result

catalogue = MediaCatalogue()


try:
    movie1 = Movie('The Matrix', 1999, 'The Wachowskis', 136)
    catalogue.add(movie1)
    movie2 = Movie('Inception', 2010, 'Christopher Nolan', 148)
    catalogue.add(movie2)
--fcc-editable-region--
    series1 = TVSeries('Scrubs', 2001, 'Bill Lawrence', 24, 9, 182)
    print(series1)
--fcc-editable-region--
    print(catalogue)
except ValueError as e:
    print(f'Validation Error: {e}')
```
