---
id: 68b810b125078b2c943ce4e5
title: Step 22
challengeType: 20
dashedName: step-22
---

# --description--

Within the `TVSeries` class, create a `__str__` method that returns a string with the following format: `title (year) - S seasons, N episodes, duration min avg, director`, where `title`, `year`, `S`, `N`, `duration`, and `director` should be replaced by `title`, `year`, `seasons`, `total_episodes`, `duration` and `director` attributes, respectively.

# --hints--

Your `TVSeries` class should have a `__str__` method.

```js
({
  test: () => runPython(`assert _Node(_code).find_class("TVSeries").has_function("__str__")`)
})
```

Your `__str__` method should return a string in the format `title (year) - S seasons, N episodes, duration min avg, director`.

```js
({
    test: () => runPython(`
    import io
    import sys
        
    captured_output = io.StringIO()
    sys.stdout = captured_output
        
    series1 = TVSeries('Scrubs', 2001, 'Bill Lawrence', 24, 9, 182)
    print(series1)
        
    sys.stdout = sys.__stdout__
    output = captured_output.getvalue()
        
    assert "Scrubs (2001) - 9 seasons, 182 episodes, 24 min avg, Bill Lawrence" in output
    `)
})
```

# --seed--

## --seed-contents--

```py
class Movie:
    def __init__(self, title, year, director, duration):
        if not title.strip():
            raise ValueError('Title cannot be empty')
        if year < 1895:
            raise ValueError('Year must be 1895 or later')
        if not director.strip():
            raise ValueError('Director cannot be empty')
        if duration <= 0:
            raise ValueError('Duration must be positive')
        self.title = title
        self.year = year
        self.director = director
        self.duration = duration

    def __str__(self):
        return f'{self.title} ({self.year}) - {self.duration} min, {self.director}'

class TVSeries(Movie):
    def __init__(self, title, year, director, duration, seasons, total_episodes):
        super().__init__(title, year, director, duration)

        if seasons < 1:
            raise ValueError('Seasons must be 1 or greater')
        if total_episodes < 1:
            raise ValueError('Total episodes must be 1 or greater')
        
        self.seasons = seasons
        self.total_episodes = total_episodes
--fcc-editable-region--
    
--fcc-editable-region--
class MediaCatalogue:
    def __init__(self):
        self.items = []

    def add(self, media_item):
        self.items.append(media_item)

    def __str__(self):
        if not self.items:
            return 'Media Catalogue (empty)'

        result = f'Media Catalogue ({len(self.items)} items):\n\n'
        
        for i, movie in enumerate(self.items, 1):
            result += f'{i}. {movie}\n'
        return result

catalogue = MediaCatalogue()


try:
    movie1 = Movie('The Matrix', 1999, 'The Wachowskis', 136)
    catalogue.add(movie1)
    movie2 = Movie('Inception', 2010, 'Christopher Nolan', 148)
    catalogue.add(movie2)

    series1 = TVSeries('Scrubs', 2001, 'Bill Lawrence', 24, 9, 182)

    print(catalogue)
except ValueError as e:
    print(f'Validation Error: {e}')
```
