---
id: 68b9999b6cfccc74e268c0f1
title: Step 40
challengeType: 20
dashedName: step-40
---

# --description--

Before your `for` loop, create an `if` statement that adds the string `=== MOVIES ===` (ending with a newline character) to the current value of `result` when the `movies` list is not empty.

# --hints--

You should have an `if` statement in your `__str__` method that checks if the `movies` list is not empty.

```js
({
  test: () => runPython(`
  cond = _Node(_code).find_class("MediaCatalogue").find_function("__str__").find_ifs()[1].find_conditions()[0]
  conds = ["movies", "len(movies)", "len(movies) > 0"]
  assert any(cond.is_equivalent(c) for c in conds)  
  `)
})
```

You should have `result += '=== MOVIES ===\n'` inside your `if` statement.

```js
({
  test: () => runPython(`
    assert _Node(_code).find_class("MediaCatalogue").find_function("__str__").find_ifs()[1].find_body().has_stmt("result += '=== MOVIES ===\\\\n'")
  `)
})
```

# --seed--

## --seed-contents--

```py
class MediaError(Exception):
    """Custom exception for media-related errors."""

    def __init__(self, message, obj):
        super().__init__(message)
        self.obj = obj

class Movie:
    """Parent class representing a movie."""
    
    def __init__(self, title, year, director, duration):
        if not title.strip():
            raise ValueError('Title cannot be empty')
        if year < 1895:
            raise ValueError('Year must be 1895 or later')
        if not director.strip():
            raise ValueError('Director cannot be empty')
        if duration <= 0:
            raise ValueError('Duration must be positive')
        self.title = title
        self.year = year
        self.director = director
        self.duration = duration

    def __str__(self):
        return f'{self.title} ({self.year}) - {self.duration} min, {self.director}'

class TVSeries(Movie):
    """Child class representing an entire TV series."""

    def __init__(self, title, year, director, duration, seasons, total_episodes):
        super().__init__(title, year, director, duration)

        if seasons < 1:
            raise ValueError('Seasons must be 1 or greater')
        if total_episodes < 1:
            raise ValueError('Total episodes must be 1 or greater')
        
        self.seasons = seasons
        self.total_episodes = total_episodes

    def __str__(self):
        return f'{self.title} ({self.year}) - {self.seasons} seasons, {self.total_episodes} episodes, {self.duration} min avg, {self.director}'

class MediaCatalogue:
    """A catalogue that can store different types of media items."""

    def __init__(self):
        self.items = []

    def add(self, media_item):
        if not isinstance(media_item, Movie):
            raise MediaError('Only Movie or TVSeries instances can be added', media_item)
        self.items.append(media_item)

    def get_movies(self):
        return [item for item in self.items if type(item) is Movie]

    def get_tv_series(self):
        return [item for item in self.items if isinstance(item, TVSeries)]
    
    def __str__(self):
        if not self.items:
            return 'Media Catalogue (empty)'
        
        movies = self.get_movies()
        series = self.get_tv_series()

        result = f'Media Catalogue ({len(self.items)} items):\n\n'
--fcc-editable-region--
        
        for i, movie in enumerate(self.items, 1):
            result += f'{i}. {movie}\n'
--fcc-editable-region--
        return result

catalogue = MediaCatalogue()

try:
    movie1 = Movie('The Matrix', 1999, 'The Wachowskis', 136)
    catalogue.add(movie1)
    movie2 = Movie('Inception', 2010, 'Christopher Nolan', 148)
    catalogue.add(movie2)

    series1 = TVSeries('Scrubs', 2001, 'Bill Lawrence', 24, 9, 182)
    catalogue.add(series1)
    series2 = TVSeries('Breaking Bad', 2008, 'Vince Gilligan', 47, 5, 62)
    catalogue.add(series2)

    print(catalogue)
except ValueError as e:
    print(f'Validation Error: {e}')
except MediaError as e:
    print(f'Media Error: {e}')
    print(f'Unable to add {e.obj}: {type(e.obj)}')

```
