---
id: 6846e3e61271e1f164636b13
title: Step 21
challengeType: 20
dashedName: step-21
---

# --description--

Now you are going to make the validation more granular. Create a function named `find_invalid_records` to find invalid values in a dictionary. Give it the following parameters: `patient_id`, `age`, `gender`, `diagnosis`, `medications`, `last_visit_id`.

Inside your new function, create an empty dictionary named `constraints`. Then, return `constraints` from your new function.

# --hints--

You should have a function named `find_invalid_records`.

```js
({ test: () => runPython(`
assert _Node(_code).has_function("find_invalid_records")
`) })
```

Your `find_invalid_records` function should have the following parameters: `patient_id`, `age`, `gender`, `diagnosis`, `medications`, `last_visit_id`, in this order.

```js
({ test: () => runPython(`
assert _Node(_code).find_function("find_invalid_records").has_args("patient_id, age, gender, diagnosis, medications, last_visit_id")
`) })
```

You should have a variable named `constraints` with the value of an empty dictionary inside your new function.

```js
({ test: () => assert(runPython(`
_foo = _Node(_code).find_function("find_invalid_records")
_foo.has_stmt("constraints = {}") or _foo.has_stmt("constraints = dict()")
`)) })
```

You should return the `constraints` dictionary from your `find_invalid_records` function.

```js
({ test: () => runPython(`
assert _Node(_code).find_function("find_invalid_records").has_return("constraints")
`) })
```

# --seed--

## --seed-contents--

```py
medical_records = [
    {
        'patient_id': 'P1001',
        'age': 34,
        'gender': 'Female',
        'diagnosis': 'Hypertension',
        'medications': ['Lisinopril'],
        'last_visit_id': 'V2301',
    },
    {
        'patient_id': 'p1002',
        'age': 47,
        'gender': 'male',
        'diagnosis': 'Type 2 Diabetes',
        'medications': ['Metformin', 'Insulin'],
        'last_visit_id': 'v2302',
    },
    {
        'patient_id': 'P1003',
        'age': 29,
        'gender': 'female',
        'diagnosis': 'Asthma',
        'medications': ['Albuterol'],
        'last_visit_id': 'v2303',
    },
    {
        'patient_id': 'p1004',
        'age': 56,
        'gender': 'Male',
        'diagnosis': 'Chronic Back Pain',
        'medications': ['Ibuprofen', 'Physical Therapy'],
        'last_visit_id': 'V2304',
    }
]

--fcc-editable-region--

--fcc-editable-region--

def validate(data):
    is_sequence = isinstance(data, (list, tuple))

    if not is_sequence:
        print('Invalid format: expected a list or tuple.')
        return False
        
    is_invalid = False
    key_set = set(
        ['patient_id', 'age', 'gender', 'diagnosis', 'medications', 'last_visit_id']
    )

    for index, dictionary in enumerate(data):
        if not isinstance(dictionary, dict):
            print(f'Invalid format: expected a dictionary at position {index}.')
            is_invalid = True

        if set(dictionary.keys()) != key_set:
            print(
                f'Invalid format: {dictionary} at position {index} has missing and/or invalid keys.'
            )
            is_invalid = True

    if is_invalid:
        return False
    print('Valid format.')
    return True

validate(medical_records)

```
