---
id: 684fdb4386b473631d8e27ca
title: Step 27
challengeType: 20
dashedName: step-27
---

# --description--

Regular expressions can contain special sequences consisting in a backslash (`\`) followed by a character. These sequences have a special meaning. For example, `\d` matches a decimal digit.

```py
import re

book = "Fahrenheit 451"
print(re.search('\d', book))
# <re.Match object; span=(11, 12), match='4'>
```

After the letter `p`, `patient_id` should have a series of numbers. So, modify your regex pattern to have the character `p` followed by the special sequence `\d`.

# --hints--

You should modify your regex pattern to be `p\d`.

```js
({ test: () => runPython(`
assert _Node(_code).find_function("find_invalid_records").find_variable("constraints").is_equivalent("constraints = {'patient_id': isinstance(patient_id, str) and re.search('p\\d', patient_id, re.IGNORECASE)}")
`) })
```

# --seed--

## --seed-contents--

```py
import re


medical_records = [
    {
        'patient_id': 'P1001',
        'age': 34,
        'gender': 'Female',
        'diagnosis': 'Hypertension',
        'medications': ['Lisinopril'],
        'last_visit_id': 'V2301',
    },
    {
        'patient_id': 'p1002',
        'age': 47,
        'gender': 'male',
        'diagnosis': 'Type 2 Diabetes',
        'medications': ['Metformin', 'Insulin'],
        'last_visit_id': 'v2302',
    },
    {
        'patient_id': 'P1003',
        'age': 29,
        'gender': 'female',
        'diagnosis': 'Asthma',
        'medications': ['Albuterol'],
        'last_visit_id': 'v2303',
    },
    {
        'patient_id': 'p1004',
        'age': 56,
        'gender': 'Male',
        'diagnosis': 'Chronic Back Pain',
        'medications': ['Ibuprofen', 'Physical Therapy'],
        'last_visit_id': 'V2304',
    }
]


def find_invalid_records(
    patient_id, age, gender, diagnosis, medications, last_visit_id
):

--fcc-editable-region--
    constraints = {
        'patient_id': isinstance(patient_id, str) and re.search('p', patient_id, re.IGNORECASE)
    }
--fcc-editable-region--

    return constraints

def validate(data):
    is_sequence = isinstance(data, (list, tuple))

    if not is_sequence:
        print('Invalid format: expected a list or tuple.')
        return False
        
    is_invalid = False
    key_set = set(
        ['patient_id', 'age', 'gender', 'diagnosis', 'medications', 'last_visit_id']
    )

    for index, dictionary in enumerate(data):
        if not isinstance(dictionary, dict):
            print(f'Invalid format: expected a dictionary at position {index}.')
            is_invalid = True

        if set(dictionary.keys()) != key_set:
            print(
                f'Invalid format: {dictionary} at position {index} has missing and/or invalid keys.'
            )
            is_invalid = True

    if is_invalid:
        return False
    print('Valid format.')
    return True

validate(medical_records)
print(find_invalid_records(**medical_records[0]))
```
