---
id: 68511bdce9282edbef75ca48
title: Step 35
challengeType: 20
dashedName: step-35
---

# --description--

As you learned in a previous lesson, a list comprehension can be used to create a list starting from an existing iterable:

```py
squares = [0, 1, 4, 9, 16, 25]

roots = [i ** 0.5 for i in squares]
print(roots) # [0.0, 1.0, 2.0, 3.0, 4.0, 5.0]
```

Each item in the `medications` list should be a string. In this step and the next one you'll write an expression to check that. Use the `and` operator to add another expression to the value of the `medications` key.

On the right side of the `and` operator, use the list comprehension syntax to create a list made by evaluating `isinstance(i, str)` for each `i` in `medications`.

# --hints--

The `medications` key of your `constraints` dictionary should have the value of `isinstance(medications, list) and [isinstance(i, str) for i in medications]`.

```js
({ test: () => assert(runPython(`
_target = _Node(_code).find_function("find_invalid_records").find_variable("constraints").tree.value
_keys = [k.value for k in _target.keys]
_index = _keys.index('medications')
_val = _target.values[_index]
_Node(_val).is_equivalent("isinstance(medications, list) and [isinstance(i, str) for i in medications]")
`)) })
```

# --seed--

## --seed-contents--

```py
import re


medical_records = [
    {
        'patient_id': 'P1001',
        'age': 34,
        'gender': 'Female',
        'diagnosis': 'Hypertension',
        'medications': ['Lisinopril'],
        'last_visit_id': 'V2301',
    },
    {
        'patient_id': 'p1002',
        'age': 47,
        'gender': 'male',
        'diagnosis': 'Type 2 Diabetes',
        'medications': ['Metformin', 'Insulin'],
        'last_visit_id': 'v2302',
    },
    {
        'patient_id': 'P1003',
        'age': 29,
        'gender': 'female',
        'diagnosis': 'Asthma',
        'medications': ['Albuterol'],
        'last_visit_id': 'v2303',
    },
    {
        'patient_id': 'p1004',
        'age': 56,
        'gender': 'Male',
        'diagnosis': 'Chronic Back Pain',
        'medications': ['Ibuprofen', 'Physical Therapy'],
        'last_visit_id': 'V2304',
    }
]


def find_invalid_records(
    patient_id, age, gender, diagnosis, medications, last_visit_id
):

    constraints = {
        'patient_id': isinstance(patient_id, str) and re.fullmatch('p\d+', patient_id, re.IGNORECASE),
        'age': isinstance(age, int) and age >= 18,
        'gender': isinstance(gender, str) and gender.lower() in ('male', 'female'),
        'diagnosis': isinstance(diagnosis, str) or diagnosis is None,
--fcc-editable-region--
        'medications': isinstance(medications, list)
--fcc-editable-region--
    }

    return constraints

def validate(data):
    is_sequence = isinstance(data, (list, tuple))

    if not is_sequence:
        print('Invalid format: expected a list or tuple.')
        return False
        
    is_invalid = False
    key_set = set(
        ['patient_id', 'age', 'gender', 'diagnosis', 'medications', 'last_visit_id']
    )

    for index, dictionary in enumerate(data):
        if not isinstance(dictionary, dict):
            print(f'Invalid format: expected a dictionary at position {index}.')
            is_invalid = True

        if set(dictionary.keys()) != key_set:
            print(
                f'Invalid format: {dictionary} at position {index} has missing and/or invalid keys.'
            )
            is_invalid = True

    if is_invalid:
        return False
    print('Valid format.')
    return True

validate(medical_records)
print(find_invalid_records(**medical_records[0]))
```
