---
id: 68517af94b02d6cc2bc08280
title: Step 40
challengeType: 20
dashedName: step-40
---

# --description--

List comprehensions also accepts `if` clauses to filter out items from an iterable:

```py
nums = [1, 2, 3, 4, 5, 6]
even_nums = [num for num in nums if num % 2 == 0]
print(even_nums) # [2, 4, 6]
```

Since you want to return a list containing only invalid keys, add an `if` clause to your comprehension so that each `key` is added to the list only when `value` is falsy.

# --hints--

Your `find_invalid_records` function should return a list comprehension that evaluates `key` for each `key, value` in `constraints.items()` if `value` is falsy.

```js
({ test: () => assert(runPython(`
_if_clause = _Node(_code).find_function("find_invalid_records").find_return().find_comp_ifs()[0]
_if_clause.is_equivalent("not value") or _if_clause.is_equivalent("value == False")
`)) })
```

Your `find_invalid_records` function should return a list comprehension that iterates over `constraints.items()`.

```js
({ test: () => assert(runPython(`
_iter = _Node(_code).find_function("find_invalid_records").find_return().find_comp_iters()[0]
_iter.is_equivalent("constraints.items()")
`)) })
```

Your `find_invalid_records` function should return a list comprehension that uses `key, value` to iterate over `constraints.items()`.

```js
({ test: () => assert(runPython(`
_target = _Node(_code).find_function("find_invalid_records").find_return().find_comp_targets()[0]
_target.is_equivalent("key, value")
`)) })
```

Your `find_invalid_records` function should return a list comprehension that evaluates `key` for each `key, value` in `constraints.items()`.

```js
({ test: () => assert(runPython(`
_expr = _Node(_code).find_function("find_invalid_records").find_return().find_comp_expr()
_expr.is_equivalent("key")
`)) })
```

# --seed--

## --seed-contents--

```py
import re


medical_records = [
    {
        'patient_id': 'P1001',
        'age': 34,
        'gender': 'Female',
        'diagnosis': 'Hypertension',
        'medications': ['Lisinopril'],
        'last_visit_id': 'V2301',
    },
    {
        'patient_id': 'p1002',
        'age': 47,
        'gender': 'male',
        'diagnosis': 'Type 2 Diabetes',
        'medications': ['Metformin', 'Insulin'],
        'last_visit_id': 'v2302',
    },
    {
        'patient_id': 'P1003',
        'age': 29,
        'gender': 'female',
        'diagnosis': 'Asthma',
        'medications': ['Albuterol'],
        'last_visit_id': 'v2303',
    },
    {
        'patient_id': 'p1004',
        'age': 56,
        'gender': 'Male',
        'diagnosis': 'Chronic Back Pain',
        'medications': ['Ibuprofen', 'Physical Therapy'],
        'last_visit_id': 'V2304',
    }
]


def find_invalid_records(
    patient_id, age, gender, diagnosis, medications, last_visit_id
):

    constraints = {
        'patient_id': isinstance(patient_id, str)
        and re.fullmatch('p\d+', patient_id, re.IGNORECASE),
        'age': isinstance(age, int) and age >= 18,
        'gender': isinstance(gender, str) and gender.lower() in ('male', 'female'),
        'diagnosis': isinstance(diagnosis, str) or diagnosis is None,
        'medications': isinstance(medications, list)
        and all([isinstance(i, str) for i in medications]),
        'last_visit_id': isinstance(last_visit_id, str)
        and re.fullmatch('v\d+', last_visit_id, re.IGNORECASE)
    }
--fcc-editable-region--
    return [key for key, value in constraints.items()]
--fcc-editable-region--
def validate(data):
    is_sequence = isinstance(data, (list, tuple))

    if not is_sequence:
        print('Invalid format: expected a list or tuple.')
        return False
        
    is_invalid = False
    key_set = set(
        ['patient_id', 'age', 'gender', 'diagnosis', 'medications', 'last_visit_id']
    )

    for index, dictionary in enumerate(data):
        if not isinstance(dictionary, dict):
            print(f'Invalid format: expected a dictionary at position {index}.')
            is_invalid = True

        if set(dictionary.keys()) != key_set:
            print(
                f'Invalid format: {dictionary} at position {index} has missing and/or invalid keys.'
            )
            is_invalid = True

    if is_invalid:
        return False
    print('Valid format.')
    return True

validate(medical_records)
print(find_invalid_records(**medical_records[0]))
```
