---
id: 672137c47fa88d6f753f6d0b
title: Step 12
challengeType: 0
dashedName: step-12
---

# --description--

Currently, your `instrumentCards` function returns an array with instrument objects, so you'll need another couple of steps before you can display your instrument cards on the page.

Modify your function so that it returns an array of strings containing the HTML code to display the instrument cards, each string corresponding to an object in the `instruments` array. The strings should have this format `<div class="card"><h2>[instrument]</h2><p>$[price]</p></div>`

# --before-all--

```js
const allInstrmnts = [
  { category: "woodwinds", instrument: "Flute", price: 500 },
  { category: "woodwinds", instrument: "Clarinet", price: 200 },
  { category: "woodwinds", instrument: "Oboe", price: 4000 },
  { category: "brass", instrument: "Trumpet", price: 200 },
  { category: "brass", instrument: "Trombone", price: 300 },
  { category: "brass", instrument: "French Horn", price: 4300 },
  { category: "percussion", instrument: "Drum Set", price: 500 },
  { category: "percussion", instrument: "Xylophone", price: 3000 },
  { category: "percussion", instrument: "Cymbals", price: 200 },
  { category: "percussion", instrument: "Marimba", price: 3000 }
]
function getInstrumentsArr(instrumentCategory) {
  const instruments =
    instrumentCategory === "all"
      ? JSON.parse(JSON.stringify(allInstrmnts))
      : allInstrmnts.filter(
          ({ category }) => category === instrumentCategory
        );

  return instruments
}

const regex = /<\s*div\s+class=('|")card\1\s*>\s*<\s*h2\s*>[\s\w]+?<\/\s*h2\s*>\s*<\s*p\s*>\$\d+?<\/\s*p\s*>\s*<\/\s*div\s*>/;
```

# --hints--

`instrumentCards("all")` should return an array of strings representing instrument cards, each with the format `<div class="card"><h2>[instrument]</h2><p>$[price]</p></div>`.

```js
const all = instrumentCards("all");
assert.isNotEmpty(all);
all.forEach(i => {
  assert.match(i, regex)
})
```

`instrumentCards("woodwinds")` should return an array of strings representing instrument cards, each with the format `<div class="card"><h2>[instrument]</h2><p>$[price]</p></div>`.

```js
const woodwinds = instrumentCards("woodwinds");
assert.isNotEmpty(woodwinds);
woodwinds.forEach(i => {
  assert.match(i, regex)
})
```

`instrumentCards("brass")` should return an array of strings representing instrument cards, each with the format `<div class="card"><h2>[instrument]</h2><p>$[price]</p></div>`.

```js
const brass = instrumentCards("brass");
assert.isNotEmpty(brass);
brass.forEach(i => {
  assert.match(i, regex)
})
```

`instrumentCards("percussion")` should return an array of strings representing instrument cards, each with the format `<div class="card"><h2>[instrument]</h2><p>$[price]</p></div>`.

```js
const percussion = instrumentCards("percussion");
assert.isNotEmpty(percussion);
percussion.forEach(i => {
  assert.match(i, regex)
})
```

`instrumentCards("all")` should return an array with ten strings representing the instrument cards for all the instruments on your page.

```js
const instrArr = getInstrumentsArr("all");
const testDiv = document.createElement("div");
testDiv.innerHTML = instrumentCards("all").join("");
const cards = testDiv.querySelectorAll('div[class="card"]');
assert.lengthOf(cards, 10);
Array.from(cards).forEach(card => {
  const h2 = card.firstElementChild;
  assert.equal(h2.tagName, "H2");
  const instrObjIndex = instrArr.findIndex(el => el.instrument === h2.innerText);
  const p = card.lastElementChild;
  assert.equal(p.tagName, "P");
  assert.equal(p.previousElementSibling, h2);
  assert.equal(p.innerText, `$${instrArr[instrObjIndex].price}`);
  instrArr.splice(instrObjIndex, 1);
})
assert.isEmpty(instrArr);
```

`instrumentCards("woodwinds")` should return an array with three strings representing the instrument cards for the woodwind instruments on your page.

```js
const instrArr = getInstrumentsArr("woodwinds");
const testDiv = document.createElement("div");
testDiv.innerHTML = instrumentCards("woodwinds").join("");
const cards = testDiv.querySelectorAll('div[class="card"]');
assert.lengthOf(cards, 3);
Array.from(cards).forEach(card => {
  const h2 = card.firstElementChild;
  assert.equal(h2.tagName, "H2");
  const instrObjIndex = instrArr.findIndex(el => el.instrument === h2.innerText);
  const p = card.lastElementChild;
  assert.equal(p.tagName, "P");
  assert.equal(p.previousElementSibling, h2);
  assert.equal(p.innerText, `$${instrArr[instrObjIndex].price}`);
  instrArr.splice(instrObjIndex, 1);
})
assert.isEmpty(instrArr);
```

`instrumentCards("brass")` should return an array with three strings representing the instrument cards for the brass instruments on your page.

```js
const instrArr = getInstrumentsArr("brass");
const testDiv = document.createElement("div");
testDiv.innerHTML = instrumentCards("brass").join("");
const cards = testDiv.querySelectorAll('div[class="card"]');
assert.lengthOf(cards, 3);
Array.from(cards).forEach(card => {
  const h2 = card.firstElementChild;
  assert.equal(h2.tagName, "H2");
  const instrObjIndex = instrArr.findIndex(el => el.instrument === h2.innerText);
  const p = card.lastElementChild;
  assert.equal(p.tagName, "P");
  assert.equal(p.previousElementSibling, h2);
  assert.equal(p.innerText, `$${instrArr[instrObjIndex].price}`);
  instrArr.splice(instrObjIndex, 1);
})
assert.isEmpty(instrArr);
```

`instrumentCards("percussion")` should return an array with four strings representing the instrument cards for the percussion instruments on your page.

```js
const instrArr = getInstrumentsArr("percussion");
const testDiv = document.createElement("div");
testDiv.innerHTML = instrumentCards("percussion").join("");
const cards = testDiv.querySelectorAll('div[class="card"]');
assert.lengthOf(cards, 4);
Array.from(cards).forEach(card => {
  const h2 = card.firstElementChild;
  assert.equal(h2.tagName, "H2");
  const instrObjIndex = instrArr.findIndex(el => el.instrument === h2.innerText);
  const p = card.lastElementChild;
  assert.equal(p.tagName, "P");
  assert.equal(p.previousElementSibling, h2);
  assert.equal(p.innerText, `$${instrArr[instrObjIndex].price}`);
  instrArr.splice(instrObjIndex, 1);
})
assert.isEmpty(instrArr);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Music Instruments product page</title>
    <link rel="stylesheet" href="./styles.css" />
  </head>
  <body>
    <h1>Student Instruments</h1>

    <main>
      <select class="select-container">
        <option id="all" value="all">All</option>
        <option id="woodwinds" value="woodwinds">Woodwinds</option>
        <option id="brass" value="brass">Brass</option>
        <option id="percussion" value="percussion">Percussion</option>
      </select>

      <div class="products-container">
        <div class="card">
          <h2>Flute</h2>
          <p>$500</p>
        </div>
        <div class="card">
          <h2>Clarinet</h2>
          <p>$200</p>
        </div>
        <div class="card">
          <h2>Oboe</h2>
          <p>$4000</p>
        </div>

        <div class="card">
          <h2>Trumpet</h2>
          <p>$200</p>
        </div>
        <div class="card">
          <h2>Trombone</h2>
          <p>$300</p>
        </div>
        <div class="card">
          <h2>French Horn</h2>
          <p>$4300</p>
        </div>

        <div class="card">
          <h2>Drum Set</h2>
          <p>$500</p>
        </div>
        <div class="card">
          <h2>Xylophone</h2>
          <p>$3000</p>
        </div>
        <div class="card">
          <h2>Cymbals</h2>
          <p>$200</p>
        </div>
        <div class="card">
          <h2>Marimba</h2>
          <p>$3000</p>
        </div>
      </div>
    </main>
    <script src="./script.js"></script>
  </body>
</html>
```

```css
*,
*::before,
*::after {
  margin: 0;
  padding: 0;
  box-sizing: border-box;
}

:root {
  --dark-grey: #0a0a23;
  --white: #ffffff;
  --yellow: #f1be32;
}

body {
  background-color: var(--dark-grey);
  color: var(--white);
}

h1 {
  text-align: center;
  margin-top: 20px;
}

.select-container {
  display: block;
  margin: 25px auto;
  padding: 8px;
  border: 4px solid var(--white);
  border-radius: 4px;
  width: 200px;
}

.products-container {
  display: flex;
  flex-direction: column;
  flex-wrap: wrap;
  align-items: center;
  justify-content: center;
  gap: 20px;
}

@media (min-width: 760px) {
  .products-container {
    flex-direction: row;
  }
}

.card {
  background-color: var(--white);
  color: var(--dark-grey);
  border: 4px solid var(--yellow);
  border-radius: 5px;
  padding: 10px;
  width: 200px;
}
```

```js
const instrumentsArr = [
  { category: "woodwinds", instrument: "Flute", price: 500 },
  { category: "woodwinds", instrument: "Clarinet", price: 200 },
  { category: "woodwinds", instrument: "Oboe", price: 4000 },
  { category: "brass", instrument: "Trumpet", price: 200 },
  { category: "brass", instrument: "Trombone", price: 300 },
  { category: "brass", instrument: "French Horn", price: 4300 },
  { category: "percussion", instrument: "Drum Set", price: 500 },
  { category: "percussion", instrument: "Xylophone", price: 3000 },
  { category: "percussion", instrument: "Cymbals", price: 200 },
  { category: "percussion", instrument: "Marimba", price: 3000 }
]

const selectContainer = document.querySelector("select");
const productsContainer = document.querySelector(".products-container");
--fcc-editable-region--
function instrumentCards(instrumentCategory) {
  const instruments =
    instrumentCategory === "all"
      ? instrumentsArr
      : instrumentsArr.filter(
          ({ category }) => category === instrumentCategory
        );

  return instruments
}
--fcc-editable-region--
selectContainer.addEventListener("change", () => {
  console.log(instrumentCards(selectContainer.value));
});
```
