---
id: 688143c66d5665e4b3409977
title: Step 13
challengeType: 0
dashedName: step-13
---

# --description--

Things seem to be working except for one small issue. If you edit a note and then leave that note, you should see the `"Note saved successfully!"` message. But if you try to edit the note again, the message is still displaying. 

The desired behavior is for the message to disappear when the user focuses on the element. You can use the `focus` event for this. 

```js
element.addEventListener("focus", () => {
  // do something here 
});
```

Attach an `addEventListener` to the `noteEl` variable. The first argument should be the `"focus"` event and the second argument should be a callback function. Inside of that callback function, set the `statusEl.textContent` to an empty string. This will reset the live region when the note is focused.

And with that last change, your workshop is complete!

# --hints--

When the user focuses on the note, you should set the `statusEl.textContent` to an empty string.

```js
window.dispatchEvent(new Event("DOMContentLoaded"));

const temp = console.log;
console.log = () => {};

noteEl.innerHTML = "New content";
noteEl.dispatchEvent(new Event("blur"));

assert.equal(noteEl.innerHTML, "New content");
assert.equal(statusEl.textContent, "Note saved successfully!");

noteEl.dispatchEvent(new Event("focus"));
assert.equal(statusEl.textContent, "");
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <title>Note taking app</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <link rel="stylesheet" href="./styles.css" />
  </head>
  <body>
    <p class="helper-text">Click or tap on the card to edit your note.</p>

    <div id="note" class="note" contenteditable="true" aria-label="Note editor">
      Many languages have words that carry meanings so specific or culturally rooted that they can't be neatly translated into English. 
        
      One example is the Japanese word "tsundoku", which refers to the habit of acquiring books and letting them pile up unread, something many book lovers can relate to. Another is the Portuguese word "saudade", describing a deep, bittersweet longing for something or someone that is absent. Meanwhile, the French word "Dépaysement" captures the disorienting yet exciting feeling of being in a new place, far from home.
        
      These unique words remind us that language is more than vocabulary: it's a window into the values, habits, and emotions of the cultures that create it.
    </div>

    <div id="status" aria-live="polite"></div>
    
    <script src="script.js"></script>
  </body>
</html>
```

```css
body {
  font-family: Arial, sans-serif;
  margin: 2em;
  max-width: 700px;
  background-color: #f5f5f5;
}

.note {
  background-color: #ffffff;
  border: 1px solid #ddd;
  border-radius: 4px;
  box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
  padding: 1.5em;
  margin-bottom: 1em;
  line-height: 1.5;
  min-height: 250px;
  font-size: 16px;
  /* This is needed to preserve line breaks in the div */
  white-space: pre-wrap;
}

.note[contenteditable="true"] {
  caret-color: black;
}

.note:hover {
  background-color: #fff;
  box-shadow: 0 0 5px rgba(0,0,0,0.2);
}

.helper-text {
  font-size: 0.9rem;
  color: #666;
  margin-top: 0.5em;
  user-select: none;
  font-style: italic;
}

#status {
  color: #00471b;
  padding: 0 1em;
}
```

```js
const noteEl = document.getElementById("note");
const statusEl = document.getElementById("status");

let currentContent = "";

--fcc-editable-region--

--fcc-editable-region--

noteEl.addEventListener("blur", () => {
  const newContent = noteEl.innerHTML;

  if (currentContent === newContent) {
    return;
  }

  currentContent = newContent;
  console.log(currentContent);

  statusEl.textContent = "Note saved successfully!";
});

window.addEventListener("DOMContentLoaded", () => {
  currentContent = noteEl.textContent;
});
```

# --solutions--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <title>Note taking app</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <link rel="stylesheet" href="./styles.css" />
  </head>
  <body>
    <p class="helper-text">Click or tap on the card to edit your note.</p>

    <div id="note" class="note" contenteditable="true" aria-label="Note editor">
      Many languages have words that carry meanings so specific or culturally rooted that they can't be neatly translated into English. 
        
      One example is the Japanese word "tsundoku", which refers to the habit of acquiring books and letting them pile up unread, something many book lovers can relate to. Another is the Portuguese word "saudade", describing a deep, bittersweet longing for something or someone that is absent. Meanwhile, the French word "Dépaysement" captures the disorienting yet exciting feeling of being in a new place, far from home.
        
      These unique words remind us that language is more than vocabulary: it's a window into the values, habits, and emotions of the cultures that create it.
    </div>

    <div id="status" aria-live="polite"></div>
    
    <script src="script.js"></script>
  </body>
</html>
```

```css
body {
  font-family: Arial, sans-serif;
  margin: 2em;
  max-width: 700px;
  background-color: #f5f5f5;
}

.note {
  background-color: #ffffff;
  border: 1px solid #ddd;
  border-radius: 4px;
  box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
  padding: 1.5em;
  margin-bottom: 1em;
  line-height: 1.5;
  min-height: 250px;
  font-size: 16px;
  /* This is needed to preserve line breaks in the div */
  white-space: pre-wrap;
}

.note[contenteditable="true"] {
  caret-color: black;
}

.note:hover {
  background-color: #fff;
  box-shadow: 0 0 5px rgba(0,0,0,0.2);
}

.helper-text {
  font-size: 0.9rem;
  color: #666;
  margin-top: 0.5em;
  user-select: none;
  font-style: italic;
}

#status {
  color: #00471b;
  padding: 0 1em;
}
```

```js
const noteEl = document.getElementById("note");
const statusEl = document.getElementById("status");

let currentContent = "";

noteEl.addEventListener("focus", () => {
  statusEl.textContent = '';
})

noteEl.addEventListener("blur", () => {
  const newContent = noteEl.innerHTML;

  if (currentContent === newContent) {
    return;
  }

  currentContent = newContent;
  console.log(currentContent);

  statusEl.textContent = "Note saved successfully!";
});

window.addEventListener("DOMContentLoaded", () => {
  currentContent = noteEl.textContent;
});
```
