---
id: 685c49c6e1db1c74a9762eae
title: Step 16
challengeType: 0
dashedName: step-16
---

# --description--

If you look at your HTML, the first `tab` is already selected by default and has an `aria-selected` attribute set to `"true"`. When a user clicks on a different tab, all tabs should first be set to `aria-selected="false"`. 

To accomplish this, you can use the `setAttribute` method to change the `aria-selected` attribute of each tab.

Here is an example of how to use the `setAttribute` method on a list of `div` elements:

```js
const divs = document.querySelectorAll("div");
divs.forEach(div => {
  div.setAttribute("class", "new-class");
});
```

Use a `forEach` on the `tabs` collection to loop through each tab and set its `aria-selected` attribute to `"false"`. For the callback function, you can use any parameter name you like but it is best not to use `tab` since that is already being used in the outer `forEach` loop.

# --hints--

When the user clicks on a tab, all of the tabs should have their `aria-selected` attribute set to `"false"`.

```js
const allTabs = document.querySelectorAll('[role="tab"]');
allTabs.forEach(tab => {
  tab.click();
  assert.equal(tab.getAttribute("aria-selected"), "false");
});
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Planets Facts</title>
    <link rel="stylesheet" href="./styles.css" />
  </head>
  <body>
    <div class="tabs">
      <h2 id="tabs-title">Planets</h2>
      <div role="tablist" aria-labelledby="tabs-title">
        <button role="tab" aria-controls="panel-earth" aria-selected="true" id="tab-earth">🌍 Earth</button>
        <button role="tab" aria-controls="panel-saturn" aria-selected="false" id="tab-saturn">🪐 Saturn</button>
        <button role="tab" aria-controls="panel-mars" aria-selected="false" id="tab-mars">🔴 Mars</button>
      </div>

      <div id="panel-earth" role="tabpanel" aria-labelledby="tab-earth">
        <p>
          Earth is our home planet, known for its abundant water, diverse ecosystems, and life-supporting atmosphere. It's the only planet in the solar system known to harbor life.
        </p>
      </div>
      <div id="panel-saturn" role="tabpanel" aria-labelledby="tab-saturn" hidden>
        <p>
          Saturn is famous for its beautiful and extensive ring system made of ice and rock particles. It's a gas giant with dozens of moons orbiting it.
        </p>
      </div>
      <div id="panel-mars" role="tabpanel" aria-labelledby="tab-mars" hidden>
        <p>
          Mars, the red planet, is a rocky world with the tallest volcano and deepest canyon in the solar system. It's a key focus for exploration in the search for past or present life.
        </p>
      </div>
    </div>

    <script src="script.js"></script>
  </body>
</html>
```

```css
.tabs [role="tablist"] {
  display: flex;
  gap: 0.5rem;
  margin-bottom: 1rem;
}

[role="tab"] {
  padding: 0.5rem 1rem;
  background: #eee;
  border: 1px solid #ccc;
  cursor: pointer;
  font-weight: bold;
}

[role="tab"][aria-selected="true"] {
  background: #fff;
  border-bottom: 2px solid dodgerblue;
}

[role="tabpanel"] {
  border: 1px solid #ccc;
  padding: 1rem;
}
```

```js
const tabs = document.querySelectorAll('[role="tab"]');
const panels = document.querySelectorAll('[role="tabpanel"]');

--fcc-editable-region--
tabs.forEach(tab => {
  tab.addEventListener("click", () => {

  });
});
--fcc-editable-region--
```
