---
id: 67350acfd2006f2777295b96
title: Step 19
challengeType: 1
dashedName: step-19
---

# --description--

The `keys` method is directly available on the `Map` object and returns a `MapIterator` that enables you to iterate over the keys of your map.

Create a function named `displayCatalog`. Inside your function, create a `for...of` loop that iterates over the keys in `catalog` and logs each of them to the console.

Then, call `displayCatalog` and see the output in the console.

# --hints--

You should have a function named `displayCatalog`.

```js
assert.isFunction(displayCatalog);
```

You should call your `displayCatalog` function.

```js
assert.match(__helpers.removeJSComments(code), /displayCatalog\s*\(\s*\)/);
```

Your `displayCatalog` function should call the `keys` method on `catalog`.

```js
const catalogCopy = new Map(catalog);
let flag = false;
const temp = catalog.keys;
try {
    catalog.keys = () => {
        flag = true;
        return catalogCopy.keys()
    };
    displayCatalog();    
    assert.isTrue(flag);
} finally {
    catalog.keys = temp;
}
```

Your `displayCatalog` function should log each key contained in `catalog` to the console.

```js
const testArr = [];
const temp = console.log;
try {
    console.log = obj => {testArr.push(obj)};
    displayCatalog();    
    assert.isNotEmpty(testArr);
    const k = catalog.keys();
    for (let i = 0; i < catalog.size; i++) {
        assert.strictEqual(testArr[i], k.next().value)
    }
} finally {
    console.log = temp;
}
```

# --seed--

## --seed-contents--

```js
const ballerina = {
    commonName: "Spanish lavender",
    scientificName: "Lavandula stoechas",
    cultivar: "Ballerina"
}

const prettyPolly = {
    commonName: "Spanish lavender",
    scientificName: "Lavandula stoechas",
    cultivar: "Pretty Polly"
}

const willowVale = {
    commonName: "Spanish lavender",
    scientificName: "Lavandula stoechas",
    cultivar: "Willow Vale"
}

const hidcote = {
    commonName: "English lavender",
    scientificName: "Lavandula angustifolia",
    cultivar: "Hidcote"
}

const imperialGem = {
    commonName: "English lavender",
    scientificName: "Lavandula angustifolia",
    cultivar: "Imperial Gem"
}

const royalCrown = {
    commonName: "French lavender",
    scientificName: "Lavandula dentata",
    cultivar: "Royal Crown"
}

const catalog = new Map();
catalog.set(ballerina, { small: 20, medium: 15, large: 12 });
catalog.set(prettyPolly, { small: 31, medium: 14, large: 24 });
catalog.set(willowVale, { small: 3, medium: 5, large: 0 });
catalog.set(hidcote, { small: 33, medium: 13, large: 18 });
catalog.set(imperialGem, { small: 19, medium: 35, large: 28 });
catalog.set(royalCrown, { small: 40, medium: 22, large: 9 });

const removePlant = plant => catalog.delete(plant);

const sellPlants = (plant, size, potsNo) => {
    if (!catalog.has(plant)) return "Item not found.";
    const name = `${plant.scientificName} '${plant.cultivar}'`
    const pots = catalog.get(plant);
    if (pots[size] - potsNo < 0) {
        return `Not enough ${size} size pots for ${name}. Only ${pots[size]} left.`
    }
    pots[size] -= potsNo;
    return `Catalog successfully updated.`
}

--fcc-editable-region--

--fcc-editable-region--
```
