---
id: 673521668be7905059b2d555
title: Step 22
challengeType: 1
dashedName: step-22
---

# --description--

Finally, you can use the `forEach` method to run a function on each key-value pair in your map.

```js
myMap.forEach((value, key) => {console.log(key, value)});
```

Note that the callback passed to `forEach` accesses the value through its first argument and the key through its second argument for each entry. 

Modify your function to return a string containing your entire catalog and log the result to the console. Build your string using the following structure for each entry in `catalog`:

```md
<scientific-name> '<cultivar>': <small-pots> S, <medium-pots> M, <large-pots> L

```

Note that the representation of each entry should terminate with a newline character.

# --hints--

You should log the result of calling `displayCatalog` to the console.

```js
assert.match(__helpers.removeJSComments(code), /console\s*\.\s*log\s*\(\s*displayCatalog\s*\(\s*\)\s*\)/)
```

Your `displayCatalog` function should use the `forEach` method on `catalog`.

```js
let flag = false;
const temp = catalog.forEach;
try {
    catalog.forEach = obj => {flag = true};
    displayCatalog();    
    assert.isTrue(flag);    
} finally {
    catalog.forEach = temp;
}
```

`displayCatalog` should return `--fcc-expected--`, but found `--fcc-actual--`.

```js
const displayCatalogTest = () => {
    let catalogString = "";
    catalog.forEach((val, key) => {
        catalogString += `${key.scientificName} '${key.cultivar}': ${val.small} S, ${val.medium} M, ${val.large} L
`   })
    return catalogString
}
assert.equal(displayCatalog(), displayCatalogTest())
```

# --seed--

## --seed-contents--

```js
const ballerina = {
    commonName: "Spanish lavender",
    scientificName: "Lavandula stoechas",
    cultivar: "Ballerina"
}

const prettyPolly = {
    commonName: "Spanish lavender",
    scientificName: "Lavandula stoechas",
    cultivar: "Pretty Polly"
}

const willowVale = {
    commonName: "Spanish lavender",
    scientificName: "Lavandula stoechas",
    cultivar: "Willow Vale"
}

const hidcote = {
    commonName: "English lavender",
    scientificName: "Lavandula angustifolia",
    cultivar: "Hidcote"
}

const imperialGem = {
    commonName: "English lavender",
    scientificName: "Lavandula angustifolia",
    cultivar: "Imperial Gem"
}

const royalCrown = {
    commonName: "French lavender",
    scientificName: "Lavandula dentata",
    cultivar: "Royal Crown"
}

const catalog = new Map();
catalog.set(ballerina, { small: 20, medium: 15, large: 12 });
catalog.set(prettyPolly, { small: 31, medium: 14, large: 24 });
catalog.set(willowVale, { small: 3, medium: 5, large: 0 });
catalog.set(hidcote, { small: 33, medium: 13, large: 18 });
catalog.set(imperialGem, { small: 19, medium: 35, large: 28 });
catalog.set(royalCrown, { small: 40, medium: 22, large: 9 });

const removePlant = plant => catalog.delete(plant);

const sellPlants = (plant, size, potsNo) => {
    if (!catalog.has(plant)) return "Item not found.";
    const name = `${plant.scientificName} '${plant.cultivar}'`
    const pots = catalog.get(plant);
    if (pots[size] - potsNo < 0) {
        return `Not enough ${size} size pots for ${name}. Only ${pots[size]} left.`
    }
    pots[size] -= potsNo;
    return `Catalog successfully updated.`
}
--fcc-editable-region--
const displayCatalog = () => {
    for (const entry of catalog.entries()) {
        console.log(entry);
    }
}

displayCatalog()
--fcc-editable-region--
```
