---
id: 6737c6d5d66b5cc3dac09c7b
title: Step 29
challengeType: 1
dashedName: step-29
---

# --description--

Maps and Sets share a few methods that have the same name and purpose. For example you can use the `has` method on a set to check if it contains a specific element.

Use the `has` method to check if the `ballerina` object is contained in your `plantsSet` and log the result to the console.

# --hints--

You should log `plantsSet.has(ballerina)` to the console.

```js
assert.match(__helpers.removeJSComments(code), /console\s*\.\s*log\s*\(\s*plantsSet\s*\.\s*has\s*\(\s*ballerina\s*\)\s*\)/);
```

# --seed--

## --seed-contents--

```js
const ballerina = {
    commonName: "Spanish lavender",
    scientificName: "Lavandula stoechas",
    cultivar: "Ballerina"
}

const prettyPolly = {
    commonName: "Spanish lavender",
    scientificName: "Lavandula stoechas",
    cultivar: "Pretty Polly"
}

const willowVale = {
    commonName: "Spanish lavender",
    scientificName: "Lavandula stoechas",
    cultivar: "Willow Vale"
}

const hidcote = {
    commonName: "English lavender",
    scientificName: "Lavandula angustifolia",
    cultivar: "Hidcote"
}

const imperialGem = {
    commonName: "English lavender",
    scientificName: "Lavandula angustifolia",
    cultivar: "Imperial Gem"
}

const royalCrown = {
    commonName: "French lavender",
    scientificName: "Lavandula dentata",
    cultivar: "Royal Crown"
}

const catalog = new Map();
catalog.set(ballerina, { small: 20, medium: 15, large: 12 });
catalog.set(prettyPolly, { small: 31, medium: 14, large: 24 });
catalog.set(willowVale, { small: 3, medium: 5, large: 0 });
catalog.set(hidcote, { small: 33, medium: 13, large: 18 });
catalog.set(imperialGem, { small: 19, medium: 35, large: 28 });
catalog.set(royalCrown, { small: 40, medium: 22, large: 9 });

const sellPlants = (plant, size, potsNo) => {
    if (!catalog.has(plant)) return "Item not found.";
    const name = `${plant.scientificName} '${plant.cultivar}'`
    const pots = catalog.get(plant);
    if (pots[size] - potsNo < 0) {
        return `Not enough ${size} size pots for ${name}. Only ${pots[size]} left.`
    }
    pots[size] -= potsNo;
    return `Catalog successfully updated.`
}

const removePlant = plant => catalog.delete(plant);

const displayCatalog = () => {
    let catalogString = "";
    catalog.forEach((val, key) => {
        catalogString += `${key.scientificName} '${key.cultivar}': ${val.small} S, ${val.medium} M, ${val.large} L
`
    })
    return catalogString
}

const displayPlantsSet = () => {
    const catalogSet = new Set();
    catalogSet.add(ballerina);
    catalogSet.add(ballerina);
    catalogSet.add(prettyPolly);
    return catalogSet
};

const plantsSet = displayPlantsSet();
--fcc-editable-region--

--fcc-editable-region--
console.log(plantsSet);
```
