---
id: 68eaa9ef8a0867071f195f59
title: Step 10
challengeType: 0
dashedName: step-10
---

# --description--

So far you have been using the `cite` attribute to attribute the source of the quotation, but the attribute doesn't really show the source to the user.

If you want to attribute the source visually, you can add a citation element, `cite`, outside the block quotation element. The citation element is an HTML element that you can use to mark up the title of a referenced creative work, like a book, article, song, film, website, or research paper.

Here's an example:

```html
<div>
  <blockquote cite="https://www.freecodecamp.org/news/is-college-worth-it/">
    The first thing you should consider about education is this is an economic decision.
  </blockquote>
  <p>—Quincy Larson, <cite>Is College Still Worth it? Tips from my 20 Years in Adult Education</cite></p>
</div>
```

Inside the `p` element below the block quotation element, wrap `How to Learn to Code and Get a Developer Job [Full Book]` in a `cite` element.

# --hints--

You should have a `cite` element inside the `p` element below the `blockquote` element.

```js
assert.exists(document.querySelector('blockquote + p > cite'));
```

Your `cite` element should have the text `How to Learn to Code and Get a Developer Job [Full Book]`.

```js
const citeEl = document.querySelector('blockquote + p > cite');
assert.equal(citeEl?.innerText.trim(), 'How to Learn to Code and Get a Developer Job [Full Book]');
```

Ignoring the `cite` element you just added, the text of the `p` element should still be `—Quincy Larson, How to Learn to Code and Get a Developer Job [Full Book]`.

```js
const pElCleanedText = document.querySelector('blockquote + p')?.innerText.trim().replaceAll(/ {2,}/g, ' ');
assert.equal(pElCleanedText, '—Quincy Larson, How to Learn to Code and Get a Developer Job [Full Book]');
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Quincy's Tips for Getting a Developer Job</title>
  </head>
  <body>
    <h1>Quincy's Tips for Getting a Developer Job</h1>
    <p>
      Learning to code is hard, but as Quincy Larson says,
      <q cite="https://www.freecodecamp.org/news/learn-to-code-book/">You can become a developer.</q>
    </p>

    <main>
      <section>
        <h2>Envisioning Success</h2>
        <blockquote cite="https://www.freecodecamp.org/news/learn-to-code-book/">
          Can you imagine what it would be like to be a successful developer? To have built software systems that people rely upon?
        </blockquote>
--fcc-editable-region--
        <p>
          —Quincy Larson, How to Learn to Code and Get a Developer Job [Full Book]
        </p>
--fcc-editable-region--
      </section>
      <section>

      </section>
      <section>

      </section>
    </main>
  </body>
</html>
```
