---
id: 67353950c86fe2dfd84bc2f3
title: Step 11
challengeType: 0
dashedName: step-11
---

# --description--

You'll need to adjust for the number of servings being calculated. This is a great chance to use another curried function.

Declare an `adjustForServings` function, which accepts a `baseQuantity` argument. It should return a second function which accepts a `newServings` argument.

The inner function should return the result of multiplying the `baseQuantity` and `newServings`.

# --hints--

You should declare an `adjustForServings` function.

```js
assert.isFunction(adjustForServings);
```

Your `adjustForServings` function should accept a `baseQuantity` argument.

```js
assert.match(adjustForServings?.toString(), /\(baseQuantity\)/);
```

Your `adjustForServings` function should return a function.

```js
assert.isFunction(adjustForServings?.());
```

Your inner function should have a `newServings` parameter.

```js
assert.match(adjustForServings?.()?.toString(), /\(newServings\)/);
```

Your inner function should return the result of multiplying `baseQuantity` and `newServings`.

```js
assert.strictEqual(adjustForServings?.(5)?.(10), 50);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Recipe Ingredient Converter</title>
    <link rel="stylesheet" href="styles.css" />
  </head>
  <body>
    <main class="container">
      <h1>Recipe Ingredient Converter</h1>
      <form id="recipe-form">
        <div class="input-container">
          <label for="ingredient">Ingredient:</label>
          <input type="text" id="ingredient" required />
        </div>

        <div class="input-container">
          <label for="quantity">Quantity:</label>
          <input type="number" id="quantity" step="any" required />
        </div>

        <div class="input-container">
          <label for="unit">Unit:</label>
          <select id="unit">
            <option value="cup">Cup</option>
            <option value="gram">Gram</option>
            <option value="ounce">Ounce</option>
            <option value="teaspoon">Teaspoon</option>
          </select>
        </div>
        <div class="input-container">
          <label for="servings">Number of Servings:</label>
          <input type="number" id="servings" step="any" value="1" />
        </div>
        <button type="submit">Convert</button>
      </form>

      <section>
        <h2>Converted Ingredients</h2>
        <ul id="result-list"></ul>
      </section>
    </main>
    <script src="script.js"></script>
  </body>
</html>
```

```css
*,
*::before,
*::after {
  margin: 0;
  padding: 0;
  box-sizing: border-box;
}

:root {
  --dark-grey: #0a0a23;
  --white: #fff;
  --light-grey: #ddd;
  --golden-yellow: #fecc4c;
  --yellow: #ffcc4c;
  --gold: #feac32;
  --orange: #ffac33;
  --dark-orange: #f89808;
}

body {
  font-family: Arial, sans-serif;
  background-color: var(--dark-grey);
  display: flex;
  justify-content: center;
  align-items: center;
  height: 100vh;
}

h1 {
  margin: 10px 0 15px;
}

.container {
  text-align: center;
  background: var(--white);
  padding: 20px;
  border-radius: 8px;
  box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
  width: 100%;
  max-width: 600px;
}

input,
select {
  padding: 10px;
  font-size: 16px;
  margin: 5px 0;
  border: 1px solid var(--light-grey);
  border-radius: 4px;
}

button {
  font-size: 1.2rem;
  cursor: pointer;
  width: 200px;
  margin: 20px 0 30px;
  color: var(--dark-grey);
  background-color: var(--gold);
  background-image: linear-gradient(var(--golden-yellow), var(--orange));
  border-color: var(--gold);
  border-width: 3px;
}

button:hover {
  background-image: linear-gradient(var(--yellow), var(--dark-orange));
}

ul {
  list-style-type: none;
  padding: 0;
}

li {
  padding: 10px;
  border-bottom: 1px solid var(--light-grey);
  display: flex;
  justify-content: space-between;
}
```

```js
const conversionTable = {
  cup: { gram: 240, ounce: 8.0, teaspoon: 48 },
  gram: { cup: 1 / 240, ounce: 0.0353, teaspoon: 0.2 },
  ounce: { cup: 0.125, gram: 28.35, teaspoon: 6 },
  teaspoon: { cup: 1 / 48, gram: 5, ounce: 0.167 },
}

const convertQuantity = (fromUnit) => (toUnit) => (quantity) => {
  const conversionRate = conversionTable[fromUnit][toUnit];
  return quantity * conversionRate;
}

const gramsResult = convertQuantity("cup")("gram")(2);
console.log(gramsResult);

--fcc-editable-region--

--fcc-editable-region--
```
