---
id: 67353fb237ffbd01af3be1cc
title: Step 14
challengeType: 0
dashedName: step-14
---

# --description--

You can finally start hooking your logic into the user interface. You'll need to query the DOM to get a few elements by ID. Get the elements with the `ingredient`, `quantity`, `unit`, `servings`, `recipe-form`, and `result-list` IDs, and assign them to the variables `ingredientName`, `ingredientQuantity`, `unitToConvert`, `numberOfServings`, `recipeForm`, and `resultList`, respectively.

# --hints--

You should define an `ingredientName` variable.

```js
assert.isDefined(ingredientName);
```

Your `ingredientName` variable should be the element returned from `.getElementById()` with the `ingredient` ID.

```js
assert.strictEqual(ingredientName, document.getElementById('ingredient'));
```

You should define a `ingredientQuantity` variable.

```js
assert.isDefined(ingredientQuantity);
```

Your `ingredientQuantity` variable should be the element returned from `.getElementById()` with the `quantity` ID.

```js
assert.strictEqual(ingredientQuantity, document.getElementById('quantity'));
```

You should define a `unitToConvert` variable.

```js
assert.isDefined(unitToConvert);
```

Your `unitToConvert` variable should be the element returned from `.getElementById()` with the `unit` ID.

```js
assert.strictEqual(unitToConvert, document.getElementById('unit'));
```

You should define a `numberOfServings` variable.

```js
assert.isDefined(numberOfServings);
```

Your `numberOfServings` variable should be the element returned from `.getElementById()` with the `servings` ID.

```js
assert.strictEqual(numberOfServings, document.getElementById('servings'));
```

You should define a `recipeForm` variable.

```js
assert.isDefined(recipeForm);
```

Your `recipeForm` variable should be the element returned from `.getElementById()` with the `recipe-form` ID.

```js
assert.strictEqual(recipeForm, document.getElementById("recipe-form"));
```

You should define a `resultList` variable.

```js
assert.isDefined(resultList);
```

Your `resultList` variable should be the element returned from `.getElementById()` with the `result-list` ID.

```js
assert.strictEqual(resultList, document.getElementById("result-list"));
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Recipe Ingredient Converter</title>
    <link rel="stylesheet" href="styles.css" />
  </head>
  <body>
    <main class="container">
      <h1>Recipe Ingredient Converter</h1>
      <form id="recipe-form">
        <div class="input-container">
          <label for="ingredient">Ingredient:</label>
          <input type="text" id="ingredient" required />
        </div>

        <div class="input-container">
          <label for="quantity">Quantity:</label>
          <input type="number" id="quantity" step="any" required />
        </div>

        <div class="input-container">
          <label for="unit">Unit:</label>
          <select id="unit">
            <option value="cup">Cup</option>
            <option value="gram">Gram</option>
            <option value="ounce">Ounce</option>
            <option value="teaspoon">Teaspoon</option>
          </select>
        </div>
        <div class="input-container">
          <label for="servings">Number of Servings:</label>
          <input type="number" id="servings" step="any" value="1" />
        </div>
        <button type="submit">Convert</button>
      </form>

      <section>
        <h2>Converted Ingredients</h2>
        <ul id="result-list"></ul>
      </section>
    </main>
    <script src="script.js"></script>
  </body>
</html>
```

```css
*,
*::before,
*::after {
  margin: 0;
  padding: 0;
  box-sizing: border-box;
}

:root {
  --dark-grey: #0a0a23;
  --white: #fff;
  --light-grey: #ddd;
  --golden-yellow: #fecc4c;
  --yellow: #ffcc4c;
  --gold: #feac32;
  --orange: #ffac33;
  --dark-orange: #f89808;
}

body {
  font-family: Arial, sans-serif;
  background-color: var(--dark-grey);
  display: flex;
  justify-content: center;
  align-items: center;
  height: 100vh;
}

h1 {
  margin: 10px 0 15px;
}

.container {
  text-align: center;
  background: var(--white);
  padding: 20px;
  border-radius: 8px;
  box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
  width: 100%;
  max-width: 600px;
}

input,
select {
  padding: 10px;
  font-size: 16px;
  margin: 5px 0;
  border: 1px solid var(--light-grey);
  border-radius: 4px;
}

button {
  font-size: 1.2rem;
  cursor: pointer;
  width: 200px;
  margin: 20px 0 30px;
  color: var(--dark-grey);
  background-color: var(--gold);
  background-image: linear-gradient(var(--golden-yellow), var(--orange));
  border-color: var(--gold);
  border-width: 3px;
}

button:hover {
  background-image: linear-gradient(var(--yellow), var(--dark-orange));
}

ul {
  list-style-type: none;
  padding: 0;
}

li {
  padding: 10px;
  border-bottom: 1px solid var(--light-grey);
  display: flex;
  justify-content: space-between;
}
```

```js
const conversionTable = {
  cup: { gram: 240, ounce: 8.0, teaspoon: 48 },
  gram: { cup: 1 / 240, ounce: 0.0353, teaspoon: 0.2 },
  ounce: { cup: 0.125, gram: 28.35, teaspoon: 6 },
  teaspoon: { cup: 1 / 48, gram: 5, ounce: 0.167 },
}

const convertQuantity = (fromUnit) => (toUnit) => (quantity) => {
  const conversionRate = conversionTable[fromUnit][toUnit];
  return quantity * conversionRate;
}

const gramsResult = convertQuantity("cup")("gram")(2);
console.log(gramsResult);

const adjustForServings = (baseQuantity) => (newServings) =>
  baseQuantity * newServings;

const servingsResult = adjustForServings(4)(6);
console.log(servingsResult);

const processIngredient = (baseQuantity, baseUnit, newUnit, newServings) => {
  const adjustedQuantity = adjustForServings(baseQuantity)(newServings);
  const convertedQuantity =
    convertQuantity(baseUnit)(newUnit)(adjustedQuantity);
  return convertedQuantity.toFixed(2);
};

--fcc-editable-region--

--fcc-editable-region--
```
