---
id: 60fad1cafcde010995e15306
title: Step 38
challengeType: 0
dashedName: step-38
---

# --description--

With form submissions, it is useful, and good practice, to provide each submittable element with a `name` attribute. This attribute is used to identify the element in the form submission.

Except for the two `radio` inputs (which you have already named), give each submittable element a unique `name` attribute of your choosing.

# --hints--

You should give the `input` expecting a first name a `name` attribute. _PS I would have chosen `first-name`_

```js
assert.isNotEmpty(document.querySelector('fieldset:nth-child(1) > label:nth-child(1) > input')?.name);
```

You should give the `input` expecting a last name a `name` attribute. _PS I would have chosen `last-name`_

```js
assert.isNotEmpty(document.querySelector('fieldset:nth-child(1) > label:nth-child(2) > input')?.name);
```

You should give the `email` a `name` attribute. _PS I would have chosen `email`_

```js
assert.isNotEmpty(document.querySelector('input[type="email"]')?.name);
```

You should give the `password` a `name` attribute. _PS I would have chosen `password`_

```js
assert.isNotEmpty(document.querySelector('input[type="password"]')?.name);
```

You should give the `checkbox` a `name` attribute. _PS I would have chosen `terms`_

```js
assert.isNotEmpty(document.querySelector('input[type="checkbox"]')?.name);
```

You should give the `file` a `name` attribute. _PS I would have chosen `file`_

```js
assert.isNotEmpty(document.querySelector('input[type="file"]')?.name);
```

You should give the `number` a `name` attribute. _PS I would have chosen `age`_

```js
assert.isNotEmpty(document.querySelector('input[type="number"]')?.name);
```

You should give the `select` element a `name` attribute. _PS I would have chosen `referrer`_

```js
assert.isNotEmpty(document.querySelector('select')?.name);
```

You should give the `textarea` element a `name` attribute. _PS I would have chosen `bio`_

```js
assert.isNotEmpty(document.querySelector('textarea')?.name);
```

You should not give any of the `option` elements a `name` attribute.

```js
[...document.querySelectorAll('option')]?.forEach(option => assert.isUndefined(option?.name));
```

You should not give any of the `label` elements a `name` attribute.

```js
[...document.querySelectorAll('label')]?.forEach(label => assert.isUndefined(label?.name));
```

You should not give any of the `fieldset` elements a `name` attribute.

```js
[...document.querySelectorAll('fieldset')]?.forEach(fieldset => assert.isEmpty(fieldset?.name));
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8">
    <title>Registration Form</title>
    <link rel="stylesheet" href="styles.css" />
  </head>
  <body>
    <h1>Registration Form</h1>
    <p>Please fill out this form with the required information</p>
    <form method="post" action='https://register-demo.freecodecamp.org'>
--fcc-editable-region--
        <fieldset>
        <label for="first-name">Enter Your First Name: <input id="first-name" type="text" required /></label>
        <label for="last-name">Enter Your Last Name: <input id="last-name" type="text" required /></label>
        <label for="email">Enter Your Email: <input id="email" type="email" required /></label>
        <label for="new-password">Create a New Password: <input id="new-password" type="password" pattern="[a-z0-5]{8,}" required /></label>
      </fieldset>
      <fieldset>
        <legend>Account type (required)</legend>
        <label for="personal-account"><input id="personal-account" type="radio" name="account-type" value="personal" checked /> Personal</label>
        <label for="business-account"><input id="business-account" type="radio" name="account-type" value="business" /> Business</label>
      </fieldset>
      <fieldset>
        <label for="profile-picture">Upload a profile picture: <input id="profile-picture" type="file"/></label>
        <label for="age">Input your age (years): <input id="age" type="number" min="13" max="120" /></label>
        <label for="referrer">How did you hear about us?
          <select id="referrer">
            <option value="">(select one)</option>
            <option value="1">freeCodeCamp News</option>
            <option value="2">freeCodeCamp YouTube Channel</option>
            <option value="3">freeCodeCamp Forum</option>
            <option value="4">Other</option>
          </select>
        </label>
        <label for="bio">Provide a bio:
          <textarea id ="bio" rows="3" cols="30" placeholder="I like coding on the beach..."></textarea>
        </label>
      </fieldset>
      <a href="https://www.freecodecamp.org/news/terms-of-service">Read our terms and conditions</a>
      <label for="terms-and-conditions">
        <input id="terms-and-conditions" type="checkbox" required />
        I accept the terms and conditions
      </label>
      --fcc-editable-region--
      <input type="submit" value="Submit" />
    </form>
  </body>
</html>
```

```css
body {
  width: 100%;
  height: 100vh;
  margin: 0;
  background-color: #1b1b32;
  color: #f5f6f7;
}

label {
  display: block;
  margin: 0.5rem 0;
}

```

