---
id: 62b30924c5e4ef0daba23b5e
title: Step 44
challengeType: 0
dashedName: step-44
---

# --description--

The border of the last `fieldset` element looks a little out of place. 

In previous lessons, you learned how to work with the `last-of-type` CSS pseudo-class like this: 

```css
p:last-of-type { }
```

That will select the last `p` element.

Create a new selector that targets the last `fieldset` element and set its `border-bottom` to `none`.

# --hints--

You can use the `:last-of-type` pseudo-class to select only the last element of a certain type.

```js
assert.exists(new __helpers.CSSHelp(document).getStyle('fieldset:last-of-type'));
```

Your `fieldset:last-of-type` should have `border-bottom` set as `none`.

```js
const borderBottom = new __helpers.CSSHelp(document).getStyle('fieldset:last-of-type')?.borderBottom;
assert.oneOf(borderBottom, ['none', 'medium none', 'medium']);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8">
    <title>Registration Form</title>
    <link rel="stylesheet" href="styles.css" />
  </head>
  <body>
    <h1>Registration Form</h1>
    <p>Please fill out this form with the required information</p>
    <form method="post" action='https://register-demo.freecodecamp.org'>
      <fieldset>
        <label for="first-name">Enter Your First Name: <input id="first-name" name="first-name" type="text" required /></label>
        <label for="last-name">Enter Your Last Name: <input id="last-name" name="last-name" type="text" required /></label>
        <label for="email">Enter Your Email: <input id="email" name="email" type="email" required /></label>
        <label for="new-password">Create a New Password: <input id="new-password" name="new-password" type="password" pattern="[a-z0-5]{8,}" required /></label>
      </fieldset>
      <fieldset>
        <legend>Account type (required)</legend>
        <label for="personal-account"><input id="personal-account" type="radio" name="account-type" value="personal" checked /> Personal</label>
        <label for="business-account"><input id="business-account" type="radio" name="account-type" value="business" /> Business</label>
      </fieldset>
      <fieldset>
        <label for="profile-picture">Upload a profile picture: <input id="profile-picture" type="file" name="file" /></label>
        <label for="age">Input your age (years): <input id="age" type="number" name="age" min="13" max="120" /></label>
        <label for="referrer">How did you hear about us?
          <select id="referrer" name="referrer">
            <option value="">(select one)</option>
            <option value="1">freeCodeCamp News</option>
            <option value="2">freeCodeCamp YouTube Channel</option>
            <option value="3">freeCodeCamp Forum</option>
            <option value="4">Other</option>
          </select>
        </label>
        <label for="bio">Provide a bio:
          <textarea id="bio" name="bio" rows="3" cols="30" placeholder="I like coding on the beach..."></textarea>
        </label>
      </fieldset>
      <a href="https://www.freecodecamp.org/news/terms-of-service">Read our terms and conditions</a>
      <label for="terms-and-conditions">
        <input name="terms" id="terms-and-conditions" type="checkbox" required />
        I accept the terms and conditions
      </label>
      <input type="submit" value="Submit" />
    </form>
  </body>
</html>
```

```css
body {
  width: 100%;
  height: 100vh;
  margin: 0;
  background-color: #1b1b32;
  color: #f5f6f7;
  font-family: Tahoma;
  font-size: 16px;
}

h1, p {
  margin: 1em auto;
  text-align: center;
}

form {
  width: 60vw;
  max-width: 500px;
  min-width: 300px;
  margin: 0 auto;
}

fieldset {
  border: none;
  padding: 2rem 0;
  border-bottom: 3px solid rgb(59, 59, 79);
}

--fcc-editable-region--

--fcc-editable-region--

label {
  display: block;
  margin: 0.5rem 0;
}

```

