---
id: 674ef2d357676e50e469165c
title: Step 6
challengeType: 0
dashedName: step-6
---

# --description--

Now, put the `Card` component into your `App` component. Give it the `name` prop set to `"Mark"`, the `title` prop set to `"Frontend developer"`, and the `bio` set to `"I like to work with different frontend technologies and play video games."`

# --hints--

You should use the `Card` component in your `App` component.

```js
  const testElem = await __helpers.prepTestComponent(window.index.App);
  const card = testElem.querySelector('.card');
  assert.exists(card);
```

You should pass the `name` prop with value `"Mark"` to your `Card` component.

```js
  const testElem = await __helpers.prepTestComponent(window.index.App);
  const card = testElem.querySelector('.card');
  assert.equal(card.querySelector('h2').textContent, 'Mark');
```

You should pass the `title` prop with value `"Frontend developer"` to your `Card` component.

```js
  const testElem = await __helpers.prepTestComponent(window.index.App);
  const card = testElem.querySelector('.card');
  assert.equal(card.querySelector('.card-title').textContent, 'Frontend developer');
```

You should pass the `bio` prop with value `"I like to work with different frontend technologies and play video games."` to your `Card` component.

```js
  const testElem = await __helpers.prepTestComponent(window.index.App);
  const card = testElem.querySelector('.card');
  assert.equal(card.querySelector('p:last-child').textContent, 'I like to work with different frontend technologies and play video games.');
```

# --seed--

## --seed-contents--

```html
<!doctype html>
<html>
  <head>
    <meta charset="UTF-8" />
    <title>Reusable Card component</title>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/react/18.3.1/umd/react.development.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/react-dom/18.3.1/umd/react-dom.development.js"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/babel-standalone/7.26.3/babel.min.js"></script>
    <script
      data-plugins="transform-modules-umd"
      type="text/babel"
      src="index.jsx"
    ></script>
     <link rel="stylesheet" href="./styles.css" />
  </head>
  <body>
    <div id="root"></div>
    <script
      data-plugins="transform-modules-umd"
      type="text/babel"
      data-presets="react"
      data-type="module"
    >
      import { App } from './index.jsx';
      ReactDOM.createRoot(document.getElementById('root')).render(
        <App />
      );
    </script>
  </body>
</html>
```

```css
:root {
  --dark-grey: #1b1b32;
  --light-grey: #f5f6f7;
  --dark-orange: #f89808;
}

body {
  background-color: var(--dark-grey);
}

.flex-container {
  display: flex;
  flex-wrap: wrap;
  justify-content: space-around;
  align-items: center;
}

.card {
  border: 5px solid var(--dark-orange);
  border-radius: 10px;
  width: 100%;
  padding: 20px;
  margin: 10px 0;
  background-color: var(--light-grey);
}

.card-title {
  border-bottom: 4px solid var(--dark-orange);
  width: fit-content;
}

@media (min-width: 768px) {
  .card {
    width: 300px;
  }
}
```

```jsx
export function Card({ name, title, bio }) {
  return (
    <div className="card">
      <h2>{name}</h2>
      <p className="card-title">{title}</p>
      <p>{bio}</p>
    </div>
  )
}

export function App() {
  return (
    <div className="flex-container">
    --fcc-editable-region--
      
    --fcc-editable-region--
    </div>
  );
}
```
