---
id: 68c80b63ca4e5eadf1fac738
title: Step 22
challengeType: 20
dashedName: step-22
---

# --description--

Right after setting the `_name` attribute to `new_name`, print `'name' updated to 'new_name'.`, where `new_name` should be replaced by the new value of `_name`.

# --hints--

You should print `'name' updated to 'new_name'.`, where `new_name` should be replaced by the new value of `_name`.

```js
({ test: () => runPython(`
    import io
    import sys
        
    captured_output = io.StringIO()
    sys.stdout = captured_output
        
    empl = Employee("Frank", "trainee")
    empl.name = "Terry"
        
    sys.stdout = sys.__stdout__
    output = captured_output.getvalue()
        
    assert "'name' updated to 'Terry'." in output
`) })
```

# --seed--

## --seed-contents--

```py
class Employee:
    _base_salaries = {
        'trainee': 1000,
        'junior': 2000,
        'mid-level': 3000,
        'senior': 4000,
    }

    def __init__(self, name, level):
        if not (isinstance(name, str) and isinstance(level, str)):
            raise TypeError("'name' and 'level' attribute must be of type 'str'.")
        if level not in Employee._base_salaries:
            raise ValueError(f"Invalid value '{level}' for 'level' attribute.")
        self._name = name
        self._level = level
        self._salary = Employee._base_salaries[level]

    def __str__(self):
        return f'{self.name}: {self.level}'

    def __repr__(self):
        return f"Employee('{self.name}', '{self.level}')"

    @property
    def name(self):
        return self._name
--fcc-editable-region--
    @name.setter
    def name(self, new_name):
        if not isinstance(new_name, str):
            raise TypeError("'name' must be a string.")
        self._name = new_name
        
--fcc-editable-region--
    @property
    def level(self):
        return self._level

    @property
    def salary(self):
        return self._salary

charlie_brown = Employee('Charlie Brown', 'trainee')
print(charlie_brown)
print(f'Base salary: ${charlie_brown.salary}')
```
