---
id: 68c9a1c241206043c81293d5
title: Step 18
challengeType: 20
dashedName: step-18
---

# --description--

Now that you have a new attribute, you're going to create a getter for it.

Create a method named `salary` with a `self` parameter and use the `@property` decorator on it. Inside the method, return `self._salary`.

# --hints--

Your `Employee` class should have a `salary` method with a `self` parameter.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("Employee").find_function("salary").has_args("self")`)) })
```

Your `salary` method should be decorated with `@property`.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("Employee").find_function("salary").has_decorators("property")`)) })
```

Your `salary` method should return `self._salary`.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("Employee").find_function("salary").has_return("self._salary")`)) })
```


# --seed--

## --seed-contents--

```py
class Employee:
    _base_salaries = {
        'trainee': 1000,
        'junior': 2000,
        'mid-level': 3000,
        'senior': 4000,
    }

    def __init__(self, name, level):
        if not (isinstance(name, str) and isinstance(level, str)):
            raise TypeError("'name' and 'level' attribute must be of type 'str'.")
        if level not in Employee._base_salaries:
            raise ValueError(f"Invalid value '{level}' for 'level' attribute.")
        self._name = name
        self._level = level
        self._salary = Employee._base_salaries[level]

    def __str__(self):
        return f'{self.name}: {self.level}'

    def __repr__(self):
        return f"Employee('{self.name}', '{self.level}')"

    @property
    def name(self):
        return self._name

    @property
    def level(self):
        return self._level
--fcc-editable-region--
    
--fcc-editable-region--
charlie_brown = Employee('Charlie Brown', 'trainee')
print(charlie_brown)
```
