---
id: 68c9a72c9dab42a15ce6972b
title: Step 25
challengeType: 20
dashedName: step-25
---

# --description--

Now you'll create a setter for the `_level` attribute. Create a method named `level` with parameters `self` and `new_level`. Decorate the method with `@level.setter`.

Inside the method, set `self._level` to `new_level`.

# --hints--

Your `Employee` class should have a `level` method with parameters `self` and `new_level`.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("Employee").find_functions("level")[1].has_args("self, new_level")`)) })
```

Your `level` method should be decorated with `@level.setter`.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("Employee").find_functions("level")[1].has_decorators("level.setter")`)) })
```

Your `level` method should set `self._level` to `new_level`.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("Employee").find_functions("level")[1].has_stmt("self._level = new_level")`)) })
```

# --seed--

## --seed-contents--

```py
class Employee:
    _base_salaries = {
        'trainee': 1000,
        'junior': 2000,
        'mid-level': 3000,
        'senior': 4000,
    }

    def __init__(self, name, level):
        if not (isinstance(name, str) and isinstance(level, str)):
            raise TypeError("'name' and 'level' attribute must be of type 'str'.")
        if level not in Employee._base_salaries:
            raise ValueError(f"Invalid value '{level}' for 'level' attribute.")
        self._name = name
        self._level = level
        self._salary = Employee._base_salaries[level]

    def __str__(self):
        return f'{self.name}: {self.level}'

    def __repr__(self):
        return f"Employee('{self.name}', '{self.level}')"

    @property
    def name(self):
        return self._name

    @name.setter
    def name(self, new_name):
        if not isinstance(new_name, str):
            raise TypeError("'name' must be a string.")
        self._name = new_name
        print(f"'name' updated to '{self.name}'.")
--fcc-editable-region--
    @property
    def level(self):
        return self._level

    
    
--fcc-editable-region--
    @property
    def salary(self):
        return self._salary

charlie_brown = Employee('Charlie Brown', 'trainee')
print(charlie_brown)
print(f'Base salary: ${charlie_brown.salary}')
```
