---
id: 68c9c3aa714bc326e026b826
title: Step 26
challengeType: 20
dashedName: step-26
---

# --description--

The new level cannot be set without checking if it's a valid level. At the beginning of your setter, create an `if` statement that raises a `ValueError` when `new_level` is not a key of `Employee._base_salaries`.

For the error message, use `Invalid value '{new_level}' for 'level' attribute.`, where `{new_level}` should be replaced by the argument passed to the setter.

# --hints--

You should have an `if` statement inside your `level` setter.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("Employee").find_functions("level")[1].find_ifs()[0]`)) })
```

When `new_level` is not a key of `Employee._base_salaries`, you should raise a `ValueError` with the message `Invalid value '{new_level}' for 'level' attribute.`, where `{new_level}` should be replaced by the argument passed to the setter.

```js
({ test: () => runPython(`
  emp = Employee('Frank', 'trainee')
  try:
    emp.level = "dreamer"
  except ValueError as e:
    assert str(e) == "Invalid value 'dreamer' for 'level' attribute."
  else:
      assert False, "Expected to raise ValueError with invalid new_level"
`) })
```

You should not raise any exception when `new_level` is a key of `Employee._base_salaries`

```js
({ test: () => runPython(`
  emp = Employee('Frank', 'trainee')
  for i in Employee._base_salaries:
    try:
      emp.level = i
    except Exception:
      assert False, "Expected not to raise any exception with valid new_level"    
`) })
```

# --seed--

## --seed-contents--

```py
class Employee:
    _base_salaries = {
        'trainee': 1000,
        'junior': 2000,
        'mid-level': 3000,
        'senior': 4000,
    }

    def __init__(self, name, level):
        if not (isinstance(name, str) and isinstance(level, str)):
            raise TypeError("'name' and 'level' attribute must be of type 'str'.")
        if level not in Employee._base_salaries:
            raise ValueError(f"Invalid value '{level}' for 'level' attribute.")
        self._name = name
        self._level = level
        self._salary = Employee._base_salaries[level]

    def __str__(self):
        return f'{self.name}: {self.level}'

    def __repr__(self):
        return f"Employee('{self.name}', '{self.level}')"

    @property
    def name(self):
        return self._name

    @name.setter
    def name(self, new_name):
        if not isinstance(new_name, str):
            raise TypeError("'name' must be a string.")
        self._name = new_name
        print(f"'name' updated to '{self.name}'.")

    @property
    def level(self):
        return self._level
--fcc-editable-region--
    @level.setter
    def level(self, new_level):
        
        self._level = new_level
    
--fcc-editable-region--
    @property
    def salary(self):
        return self._salary

charlie_brown = Employee('Charlie Brown', 'trainee')
print(charlie_brown)
print(f'Base salary: ${charlie_brown.salary}')
```
