---
id: 68cab02fd80a91042c0165b8
title: Step 34
challengeType: 20
dashedName: step-34
---

# --description--

After your existing `if` statement, create another one for when the new salary is less than the base salary for the current level.

Inside the `if` statement, raise a `ValueError` with the message `Salary must be higher than minimum salary $` followed by the base salary for the current level and a period.

# --hints--

You should have a second `if` statement in your `salary` setter.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("Employee").find_functions("salary")[1].find_ifs()[1]`)) })
```

When the new salary is less than the base salary for the current level, you should raise a `ValueError` with the message `Salary must be higher than minimum salary $` followed by the base salary for the current level and a period.

```js
({ test: () => runPython(`
  emp = Employee('Frank', 'trainee')
  built_in_print = print
  print = lambda x: x
  minimum_salary = Employee._base_salaries['trainee']
  try:
    emp.salary = minimum_salary - 1
  except ValueError as e:
    print = built_in_print
    assert str(e) == f"Salary must be higher than minimum salary \${minimum_salary}."
  else:
    assert False, "Expected to raise ValueError with invalid new_salary"
`) })
```

You should not raise any exception when `new_salary` is greater than the current salary.

```js
({ test: () => runPython(`
  emp = Employee('Frank', 'trainee')
  built_in_print = print
  print = lambda x: x
  minimum_salary = Employee._base_salaries['trainee']
  try:
    emp.salary = minimum_salary + 1
  except Exception:
    assert False, "Expected not to raise exception with valid new_salary"
  try:
    emp.salary = minimum_salary + 1000
  except Exception:
    assert False, "Expected not to raise exception with valid new_salary"
`) })
```

# --seed--

## --seed-contents--

```py
class Employee:
    _base_salaries = {
        'trainee': 1000,
        'junior': 2000,
        'mid-level': 3000,
        'senior': 4000,
    }

    def __init__(self, name, level):
        if not (isinstance(name, str) and isinstance(level, str)):
            raise TypeError("'name' and 'level' attribute must be of type 'str'.")
        if level not in Employee._base_salaries:
            raise ValueError(f"Invalid value '{level}' for 'level' attribute.")
        self._name = name
        self._level = level
        self._salary = Employee._base_salaries[level]

    def __str__(self):
        return f'{self.name}: {self.level}'

    def __repr__(self):
        return f"Employee('{self.name}', '{self.level}')"

    @property
    def name(self):
        return self._name

    @name.setter
    def name(self, new_name):
        if not isinstance(new_name, str):
            raise TypeError("'name' must be a string.")
        self._name = new_name
        print(f"'name' updated to '{self.name}'.")

    @property
    def level(self):
        return self._level

    @level.setter
    def level(self, new_level):
        if new_level not in Employee._base_salaries:
            raise ValueError(f"Invalid value '{new_level}' for 'level' attribute.")
        if new_level == self.level:
            raise ValueError(f"'{self.level}' is already the selected level.")
        if Employee._base_salaries[new_level] < Employee._base_salaries[self.level]:
            raise ValueError(f"Cannot change to lower level.")
        print(f"'{self.name}' promoted to '{new_level}'.")
        self._salary = Employee._base_salaries[new_level]
        self._level = new_level

    @property
    def salary(self):
        return self._salary
--fcc-editable-region--
    @salary.setter
    def salary(self, new_salary):
        if not isinstance(new_salary, (int, float)):
            raise TypeError("'salary' must be a number.")
        

        self._salary = new_salary
        print(f'Salary updated to ${self.salary}.')
--fcc-editable-region--

charlie_brown = Employee('Charlie Brown', 'trainee')
print(charlie_brown)
print(f'Base salary: ${charlie_brown.salary}')

charlie_brown.level = 'junior'

```
